/*
 * Decompiled with CFR 0.152.
 */
package kieker.model.repository;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import kieker.model.repository.AbstractRepository;
import kieker.model.repository.AllocationRepository;
import kieker.model.repository.OperationRepository;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.AllocationComponent;
import kieker.model.system.model.Operation;
import kieker.model.system.model.util.AllocationComponentOperationPair;

public class AllocationComponentOperationPairFactory
extends AbstractRepository {
    public static final AllocationComponentOperationPair ROOT_PAIR = new AllocationComponentOperationPair(0, OperationRepository.ROOT_OPERATION, AllocationRepository.ROOT_ALLOCATION_COMPONENT);
    private final Map<String, AllocationComponentOperationPair> pairsByName = new Hashtable<String, AllocationComponentOperationPair>();
    private final Map<Integer, AllocationComponentOperationPair> pairsById = new Hashtable<Integer, AllocationComponentOperationPair>();

    public AllocationComponentOperationPairFactory(SystemModelRepository systemFactory) {
        super(systemFactory);
    }

    public final AllocationComponentOperationPair getPairInstanceByPair(AllocationComponent allocationComponent, Operation operation) {
        AllocationComponentOperationPair inst = this.getPairByNamedIdentifier(allocationComponent.getId() + "-" + operation.getId());
        if (inst == null) {
            return this.createAndRegisterPair(operation, allocationComponent);
        }
        return inst;
    }

    private final AllocationComponentOperationPair createAndRegisterPair(Operation operation, AllocationComponent allocationComponent) {
        return this.createAndRegisterPair(allocationComponent.getId() + "-" + operation.getId(), operation, allocationComponent);
    }

    private final AllocationComponentOperationPair getPairByNamedIdentifier(String namedIdentifier) {
        return this.pairsByName.get(namedIdentifier);
    }

    public final AllocationComponentOperationPair getPairById(int id) {
        return this.pairsById.get(id);
    }

    private final AllocationComponentOperationPair createAndRegisterPair(String namedIdentifier, Operation operation, AllocationComponent allocationComponent) {
        if (this.pairsByName.containsKey(namedIdentifier)) {
            throw new IllegalArgumentException("Element with name " + namedIdentifier + "exists already");
        }
        int id = this.getAndIncrementNextId();
        AllocationComponentOperationPair newInst = new AllocationComponentOperationPair(id, operation, allocationComponent);
        this.pairsById.put(id, newInst);
        this.pairsByName.put(namedIdentifier, newInst);
        return newInst;
    }

    public final Collection<AllocationComponentOperationPair> getPairs() {
        return this.pairsById.values();
    }
}

