/*
 * Decompiled with CFR 0.152.
 */
package kieker.model.repository;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import kieker.model.repository.AbstractRepository;
import kieker.model.repository.AssemblyRepository;
import kieker.model.repository.OperationRepository;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.AssemblyComponent;
import kieker.model.system.model.Operation;
import kieker.model.system.model.util.AssemblyComponentOperationPair;

public class AssemblyComponentOperationPairFactory
extends AbstractRepository {
    public static final AssemblyComponentOperationPair ROOT_PAIR = new AssemblyComponentOperationPair(0, OperationRepository.ROOT_OPERATION, AssemblyRepository.ROOT_ASSEMBLY_COMPONENT);
    private final Map<String, AssemblyComponentOperationPair> pairsByName = new Hashtable<String, AssemblyComponentOperationPair>();
    private final Map<Integer, AssemblyComponentOperationPair> pairsById = new Hashtable<Integer, AssemblyComponentOperationPair>();

    public AssemblyComponentOperationPairFactory(SystemModelRepository systemFactory) {
        super(systemFactory);
    }

    public final AssemblyComponentOperationPair getPairInstanceByPair(AssemblyComponent assemblyComponent, Operation operation) {
        String namedIdentifier = assemblyComponent.getId() + "-" + operation.getId();
        AssemblyComponentOperationPair inst = this.getPairByNamedIdentifier(namedIdentifier);
        if (inst == null) {
            return this.createAndRegisterPair(namedIdentifier, operation, assemblyComponent);
        }
        return inst;
    }

    private AssemblyComponentOperationPair getPairByNamedIdentifier(String namedIdentifier) {
        return this.pairsByName.get(namedIdentifier);
    }

    public final AssemblyComponentOperationPair getPairById(int id) {
        return this.pairsById.get(id);
    }

    private AssemblyComponentOperationPair createAndRegisterPair(String namedIdentifier, Operation operation, AssemblyComponent assemblyComponent) {
        if (this.pairsByName.containsKey(namedIdentifier)) {
            throw new IllegalArgumentException("Element with name " + namedIdentifier + "exists already");
        }
        int id = this.getAndIncrementNextId();
        AssemblyComponentOperationPair newInst = new AssemblyComponentOperationPair(id, operation, assemblyComponent);
        this.pairsById.put(id, newInst);
        this.pairsByName.put(namedIdentifier, newInst);
        return newInst;
    }

    public final Collection<AssemblyComponentOperationPair> getPairs() {
        return this.pairsById.values();
    }

    public AssemblyComponentOperationPair getRootPair() {
        return ROOT_PAIR;
    }
}

