/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import kieker.common.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationFactory.class);

    private ConfigurationFactory() {
    }

    public static Configuration createSingletonConfiguration() {
        Configuration loadConfiguration;
        LOGGER.debug("Searching for JVM argument '{}' ...", (Object)"kieker.monitoring.configuration");
        Configuration defaultConfiguration = ConfigurationFactory.defaultConfiguration();
        defaultConfiguration.setProperty("kieker.monitoring.name", "KIEKER-SINGLETON");
        String configurationFile = System.getProperty("kieker.monitoring.configuration");
        if (configurationFile != null) {
            LOGGER.info("Loading configuration from JVM-specified location: '{}'", (Object)configurationFile);
            loadConfiguration = ConfigurationFactory.loadConfigurationFromFile(configurationFile, defaultConfiguration);
        } else {
            configurationFile = "META-INF/kieker.monitoring.properties";
            LOGGER.info("Loading properties from properties file in classpath: '{}'", (Object)configurationFile);
            loadConfiguration = ConfigurationFactory.loadConfigurationFromResource(configurationFile, defaultConfiguration);
        }
        return ConfigurationFactory.getSystemPropertiesStartingWith("kieker.monitoring.", loadConfiguration);
    }

    public static Configuration createDefaultConfiguration() {
        return new Configuration(ConfigurationFactory.defaultConfiguration());
    }

    public static Configuration createConfigurationFromFile(String configurationFile) {
        return ConfigurationFactory.loadConfigurationFromFile(configurationFile, ConfigurationFactory.defaultConfiguration());
    }

    private static Configuration defaultConfiguration() {
        return ConfigurationFactory.loadConfigurationFromResource("META-INF/kieker.monitoring.default.properties", null);
    }

    /*
     * Exception decompiling
     */
    private static Configuration loadConfigurationFromFile(String filename, Configuration defaultValues) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Configuration loadConfigurationFromResource(String propertiesFn, Configuration defaultValues) {
        URL resourceUrl = ConfigurationFactory.loadKiekerPropertiesFile(propertiesFn);
        if (resourceUrl == null) {
            LOGGER.warn("File '{}' not found in classpath", (Object)propertiesFn);
            return new Configuration(defaultValues);
        }
        try (InputStream is = resourceUrl.openStream();){
            Configuration properties = new Configuration(defaultValues);
            properties.load(is);
            Configuration configuration = properties;
            return configuration;
        }
        catch (IOException ex) {
            LOGGER.error("Error reading file '{}'", (Object)propertiesFn, (Object)ex);
        }
        return new Configuration(defaultValues);
    }

    private static URL loadKiekerPropertiesFile(String propertiesFileName) {
        String resourceName = propertiesFileName;
        if (!resourceName.startsWith("/")) {
            resourceName = "/" + resourceName;
        }
        return ConfigurationFactory.class.getResource(resourceName);
    }

    private static Configuration getSystemPropertiesStartingWith(String prefix, Configuration defaultValues) {
        Configuration configuration = new Configuration(defaultValues);
        Properties properties = System.getProperties();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String property = (String)keys.nextElement();
            if (!property.startsWith(prefix)) continue;
            configuration.setProperty(property, properties.getProperty(property));
        }
        return configuration;
    }
}

