/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller;

import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXConnectorServerMBean;
import javax.management.remote.JMXServiceURL;
import kieker.common.configuration.Configuration;
import kieker.monitoring.core.controller.AbstractController;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.IRemoteController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JMXController
extends AbstractController
implements IRemoteController {
    static final Logger LOGGER = LoggerFactory.getLogger(JMXController.class);
    private final boolean jmxEnabled;
    private final String domain;
    private final ObjectName controllerObjectName;
    private final ObjectName serverObjectName;
    private final JMXConnectorServer server;
    private final ServerNotificationListener serverNotificationListener;
    private final String port;
    private final JMXImplementation usedJMXImplementation;

    protected JMXController(Configuration configuration) {
        super(configuration);
        ObjectName controllerObjectNameTmp = null;
        ObjectName serverObjectNameTmp = null;
        JMXConnectorServerMBean serverTmp = null;
        ServerNotificationListener serverNotificationListenerTmp = null;
        String portTmp = "0";
        JMXImplementation usedJMXImplementationTmp = JMXImplementation.FALLBACK;
        this.domain = configuration.getStringProperty("kieker.monitoring.jmx.domain");
        this.jmxEnabled = configuration.getBooleanProperty("kieker.monitoring.jmx");
        if (this.jmxEnabled) {
            if (configuration.getBooleanProperty("kieker.monitoring.jmx.remote")) {
                try {
                    portTmp = configuration.getStringProperty("kieker.monitoring.jmx.remote.port");
                    try {
                        Configuration jmxProperties = configuration.getPropertiesStartingWith("com.sun.management.jmxremote");
                        serverTmp = (JMXConnectorServer)Class.forName("sun.management.jmxremote.ConnectorBootstrap").getMethod("initialize", String.class, Properties.class).invoke(null, portTmp, jmxProperties);
                        usedJMXImplementationTmp = JMXImplementation.SUN;
                    }
                    catch (Exception ignoreErrors) {
                        if (configuration.getBooleanProperty("kieker.monitoring.jmx.remote.fallback")) {
                            LOGGER.warn("Failed to initialize remote JMX server, falling back to default implementation");
                            JMXServiceURL url = new JMXServiceURL("rmi", null, Integer.parseInt(portTmp));
                            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                            serverTmp = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbs);
                            serverTmp.start();
                        }
                        LOGGER.warn("Failed to initialize remote JMX server and fallback is deactivated");
                    }
                    if (serverTmp != null && serverTmp.isActive()) {
                        serverObjectNameTmp = new ObjectName(this.domain, "type", configuration.getStringProperty("kieker.monitoring.jmx.remote.name"));
                        serverNotificationListenerTmp = new ServerNotificationListener();
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to initialize remote JMX server", (Throwable)e);
                }
            }
            if (configuration.getBooleanProperty("kieker.monitoring.jmx.MonitoringController")) {
                try {
                    controllerObjectNameTmp = new ObjectName(this.domain, "type", configuration.getStringProperty("kieker.monitoring.jmx.MonitoringController.name"));
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to initialize MonitoringController MBean", (Throwable)e);
                }
            }
        }
        this.usedJMXImplementation = usedJMXImplementationTmp;
        this.port = portTmp;
        this.server = serverTmp;
        this.controllerObjectName = controllerObjectNameTmp;
        this.serverObjectName = serverObjectNameTmp;
        this.serverNotificationListener = serverNotificationListenerTmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() {
        JMXController jMXController = this;
        synchronized (jMXController) {
            if (this.jmxEnabled && !this.isTerminated()) {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                if (this.serverObjectName != null) {
                    try {
                        mbs.registerMBean(this.server, this.serverObjectName);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to register JMXServer MBean", (Throwable)e);
                    }
                }
                if (this.controllerObjectName != null) {
                    try {
                        StandardMBean mbean = new StandardMBean(this.monitoringController, IMonitoringController.class);
                        mbs.registerMBean(mbean, this.controllerObjectName);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to register Monitoring Controller MBean", (Throwable)e);
                    }
                }
                if (this.server != null && this.server.isActive()) {
                    this.server.addNotificationListener(this.serverNotificationListener, null, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanup() {
        JMXController jMXController = this;
        synchronized (jMXController) {
            if (this.jmxEnabled) {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                if (this.controllerObjectName != null) {
                    try {
                        mbs.unregisterMBean(this.controllerObjectName);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to terminate MBean", (Throwable)e);
                    }
                }
                if (this.serverObjectName != null) {
                    try {
                        mbs.unregisterMBean(this.serverObjectName);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to terminate MBean", (Throwable)e);
                    }
                }
                if (this.server != null) {
                    try {
                        this.server.removeNotificationListener(this.serverNotificationListener);
                    }
                    catch (ListenerNotFoundException e) {
                        LOGGER.error("Failed to remove ServerNotificationListener", (Throwable)e);
                    }
                    try {
                        this.server.stop();
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to terminate JMX Server", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public String getControllerDomain() {
        return this.domain;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(255);
        sb.append("JMXController: ");
        if (this.jmxEnabled) {
            sb.append("JMX enabled (Domain: '");
            sb.append(this.domain);
            sb.append("')\n");
        } else {
            sb.append("JMX disabled\n");
        }
        if (this.controllerObjectName != null) {
            sb.append("\tMonitoringController MBean available: '");
            sb.append(this.controllerObjectName.getCanonicalName());
            sb.append("'\n");
        }
        if (this.server != null && this.server.isActive()) {
            sb.append("\tJMX remote access available:\n\t\tService URL: '");
            JMXServiceURL url = this.server.getAddress();
            switch (this.usedJMXImplementation) {
                case SUN: {
                    try {
                        sb.append(new JMXServiceURL(url.getProtocol(), url.getHost(), url.getPort(), "/jndi/rmi://" + url.getHost() + ":" + this.port + "/jmxrmi").toString());
                    }
                    catch (MalformedURLException ignoreErrors) {
                        sb.append("unable to determine JMXServiceURL (" + ignoreErrors.toString() + ")");
                    }
                    break;
                }
                default: {
                    sb.append(url.toString());
                }
            }
            sb.append("'\n");
            String[] connections = this.server.getConnectionIds();
            if (connections.length == 0) {
                sb.append("\t\tNo current remote connections\n");
            } else {
                for (String connection : connections) {
                    sb.append("\t\tRemote connection: '");
                    sb.append(connection);
                    sb.append("'\n");
                }
            }
        }
        return sb.toString();
    }

    private static final class ServerNotificationListener
    implements NotificationListener {
        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (LOGGER.isInfoEnabled()) {
                String notificationType = notification.getType();
                String connectionID = notification instanceof JMXConnectionNotification ? ((JMXConnectionNotification)notification).getConnectionId() : "unknown";
                if (notificationType.equals("jmx.remote.connection.opened")) {
                    LOGGER.info("New JMX remote connection initialized. Connection ID: {}", (Object)connectionID);
                } else if (notificationType.equals("jmx.remote.connection.closed")) {
                    LOGGER.info("JMX remote connection closed. Connection ID: {}", (Object)connectionID);
                } else {
                    LOGGER.info("{}: {} (ID: {})", new Object[]{notificationType, notification.getMessage(), connectionID});
                }
            }
        }
    }

    private static enum JMXImplementation {
        FALLBACK,
        SUN;

    }
}

