/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;

public abstract class AbstractTcpReader
implements Runnable {
    private static final int CONNECTION_CLOSED_BY_CLIENT = -1;
    protected final Logger logger;
    private final int port;
    private final int bufferCapacity;
    private volatile boolean terminated;
    private final boolean respawn;

    public AbstractTcpReader(int port, int bufferCapacity, Logger logger) {
        this.port = port;
        this.bufferCapacity = bufferCapacity;
        this.logger = logger;
        this.respawn = false;
    }

    public AbstractTcpReader(int port, int bufferCapacity, Logger logger, boolean respawn) {
        this.port = port;
        this.bufferCapacity = bufferCapacity;
        this.logger = logger;
        this.respawn = respawn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        ServerSocketChannel serversocket = null;
        try {
            serversocket = ServerSocketChannel.open();
            serversocket.socket().bind(new InetSocketAddress(this.port));
            do {
                this.logger.debug("Listening on port {}", (Object)this.port);
                try (SocketChannel socketChannel = serversocket.accept();){
                    ByteBuffer buffer = ByteBuffer.allocateDirect(this.bufferCapacity);
                    while (socketChannel.read(buffer) != -1 && !this.terminated) {
                        this.process(buffer);
                    }
                }
            } while (!this.terminated && this.respawn);
        }
        catch (IOException ex) {
            this.logger.error("Error while receiving control commands.", (Throwable)ex);
        }
        finally {
            if (null != serversocket) {
                try {
                    serversocket.close();
                }
                catch (IOException e) {
                    this.logger.debug("Failed to close TCP connection.", (Throwable)e);
                }
            }
        }
    }

    private void process(ByteBuffer buffer) {
        buffer.flip();
        try {
            while (buffer.hasRemaining()) {
                buffer.mark();
                boolean success = this.onBufferReceived(buffer);
                if (success) continue;
                buffer.reset();
                buffer.compact();
                return;
            }
            buffer.clear();
        }
        catch (BufferUnderflowException ex) {
            this.logger.warn("Unexpected buffer underflow. Resetting and compacting buffer.", (Throwable)ex);
            buffer.reset();
            buffer.compact();
        }
    }

    protected abstract boolean onBufferReceived(ByteBuffer var1);

    public void terminate() {
        this.terminated = true;
    }

    public int getPort() {
        return this.port;
    }
}

