/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.registry;

import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import kieker.monitoring.core.controller.MonitoringController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ControlFlowRegistry {
    INSTANCE;

    private static final Logger LOGGER;
    private final AtomicLong lastThreadId = new AtomicLong(MonitoringController.getInstance().isDebug() ? 0L : (long)new Random().nextInt(65536) << 47);
    private final transient ThreadLocal<Long> threadLocalTraceId = new ThreadLocal();
    private final transient ThreadLocal<Integer> threadLocalEoi = new ThreadLocal();
    private final transient ThreadLocal<Integer> threadLocalEss = new ThreadLocal();

    public final long getUniqueTraceId() {
        long id = this.lastThreadId.incrementAndGet();
        if (id == -1L) {
            return this.lastThreadId.incrementAndGet();
        }
        return id;
    }

    public final long getAndStoreUniqueThreadLocalTraceId() {
        long id = this.getUniqueTraceId();
        this.threadLocalTraceId.set(id);
        return id;
    }

    public final void storeThreadLocalTraceId(long traceId) {
        this.threadLocalTraceId.set(traceId);
    }

    public final long recallThreadLocalTraceId() {
        Long traceIdObj = this.threadLocalTraceId.get();
        if (traceIdObj == null) {
            return -1L;
        }
        return traceIdObj;
    }

    public final void unsetThreadLocalTraceId() {
        this.threadLocalTraceId.remove();
    }

    public final void storeThreadLocalEOI(int eoi) {
        this.threadLocalEoi.set(eoi);
    }

    public final int incrementAndRecallThreadLocalEOI() {
        Integer curEoi = this.threadLocalEoi.get();
        if (curEoi == null) {
            LOGGER.error("eoi has not been registered before");
            return -1;
        }
        int newEoi = curEoi + 1;
        this.threadLocalEoi.set(newEoi);
        return newEoi;
    }

    public final int recallThreadLocalEOI() {
        Integer curEoi = this.threadLocalEoi.get();
        if (curEoi == null) {
            LOGGER.error("eoi has not been registered before");
            return -1;
        }
        return curEoi;
    }

    public final void unsetThreadLocalEOI() {
        this.threadLocalEoi.remove();
    }

    public final void storeThreadLocalESS(int ess) {
        this.threadLocalEss.set(ess);
    }

    public final int recallAndIncrementThreadLocalESS() {
        Integer curEss = this.threadLocalEss.get();
        if (curEss == null) {
            LOGGER.error("ess has not been registered before");
            return -1;
        }
        this.threadLocalEss.set(curEss + 1);
        return curEss;
    }

    public final int recallThreadLocalESS() {
        Integer ess = this.threadLocalEss.get();
        if (ess == null) {
            LOGGER.error("ess has not been registered before");
            return -1;
        }
        return ess;
    }

    public final void unsetThreadLocalESS() {
        this.threadLocalEss.remove();
    }

    static {
        LOGGER = LoggerFactory.getLogger(ControlFlowRegistry.class);
        LOGGER.info("First threadId will be {}", (Object)ControlFlowRegistry.INSTANCE.lastThreadId.get());
    }
}

