/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj.jersey;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.ControlFlowRegistry;
import kieker.monitoring.core.registry.SessionRegistry;
import kieker.monitoring.probe.aspectj.AbstractAspectJProbe;
import kieker.monitoring.timer.ITimeSource;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.DeclarePrecedence;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
@DeclarePrecedence(value="kieker.monitoring.probe.aspectj.operationExecution.*,kieker.monitoring.probe.aspectj.jersey.*")
public class OperationExecutionJerseyClientInterceptor
extends AbstractAspectJProbe {
    public static final String SESSION_ID_ASYNC_TRACE = "NOSESSION-ASYNCIN";
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationExecutionJerseyClientInterceptor.class);
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final String VMNAME = CTRLINST.getHostname();
    private static final ControlFlowRegistry CF_REGISTRY = ControlFlowRegistry.INSTANCE;
    private static final SessionRegistry SESSION_REGISTRY = SessionRegistry.INSTANCE;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ OperationExecutionJerseyClientInterceptor ajc$perSingletonInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(public com.sun.jersey.api.client.ClientResponse com.sun.jersey.client.apache4.ApacheHttpClient4Handler.handle(com.sun.jersey.api.client.ClientRequest))")
    public Object operation(ProceedingJoinPoint thisJoinPoint) throws Throwable {
        int nextESS;
        int ess;
        int eoi;
        if (!OperationExecutionJerseyClientInterceptor.CTRLINST.isMonitoringEnabled()) {
            return thisJoinPoint.proceed();
        }
        String signature = this.ajc$superDispatch$kieker_monitoring_probe_aspectj_jersey_OperationExecutionJerseyClientInterceptor$signatureToLongString(thisJoinPoint.getSignature());
        if (!OperationExecutionJerseyClientInterceptor.CTRLINST.isProbeActivated(signature)) {
            return thisJoinPoint.proceed();
        }
        boolean entrypoint = true;
        String hostname = OperationExecutionJerseyClientInterceptor.VMNAME;
        String sessionId = OperationExecutionJerseyClientInterceptor.SESSION_REGISTRY.recallThreadLocalSessionId();
        long traceId = OperationExecutionJerseyClientInterceptor.CF_REGISTRY.recallThreadLocalTraceId();
        if (traceId == -1L) {
            entrypoint = true;
            traceId = OperationExecutionJerseyClientInterceptor.CF_REGISTRY.getAndStoreUniqueThreadLocalTraceId();
            OperationExecutionJerseyClientInterceptor.CF_REGISTRY.storeThreadLocalEOI(0);
            OperationExecutionJerseyClientInterceptor.CF_REGISTRY.storeThreadLocalESS(1);
            eoi = 0;
            ess = 0;
            nextESS = 1;
        } else {
            entrypoint = false;
            eoi = OperationExecutionJerseyClientInterceptor.CF_REGISTRY.incrementAndRecallThreadLocalEOI();
            ess = OperationExecutionJerseyClientInterceptor.CF_REGISTRY.recallAndIncrementThreadLocalESS();
            nextESS = ess + 1;
            if (eoi == -1 || ess == -1) {
                OperationExecutionJerseyClientInterceptor.LOGGER.error("eoi and/or ess have invalid values: eoi == {} ess == {}", (Object)eoi, (Object)ess);
                OperationExecutionJerseyClientInterceptor.CTRLINST.terminateMonitoring();
            }
        }
        Object[] args = thisJoinPoint.getArgs();
        ClientRequest request = (ClientRequest)args[0];
        URI uri = request.getUri();
        MultivaluedMap requestHeader = request.getHeaders();
        if (requestHeader == null) {
            requestHeader = new MultivaluedHashMap();
        }
        ArrayList<String> requestHeaderList = new ArrayList<String>(4);
        requestHeaderList.add(Long.toString(traceId) + "," + sessionId + "," + Integer.toString(eoi) + "," + Integer.toString(nextESS));
        requestHeader.put((Object)"OperationExecutionJerseyHeader", requestHeaderList);
        OperationExecutionJerseyClientInterceptor.LOGGER.debug("Sending request to {} with header = {}", (Object)uri.toString(), (Object)requestHeader.toString());
        long tin = OperationExecutionJerseyClientInterceptor.TIME.getTime();
        Object retval = null;
        try {
            retval = thisJoinPoint.proceed(args);
        }
        finally {
            long tout = OperationExecutionJerseyClientInterceptor.TIME.getTime();
            if (retval instanceof ClientResponse) {
                ClientResponse response = (ClientResponse)retval;
                MultivaluedMap responseHeader = response.getHeaders();
                if (responseHeader != null) {
                    List responseHeaderList = (List)responseHeader.get((Object)"OperationExecutionJerseyHeader");
                    if (responseHeaderList != null) {
                        String retSessionId;
                        OperationExecutionJerseyClientInterceptor.LOGGER.debug("Received response from {} with header = {}", (Object)uri.toString(), (Object)responseHeader.toString());
                        String[] responseHeaderArray = ((String)responseHeaderList.get(0)).split(",");
                        String retTraceIdStr = responseHeaderArray[0];
                        Long retTraceId = -1L;
                        if (!"null".equals(retTraceIdStr)) {
                            try {
                                retTraceId = Long.parseLong(retTraceIdStr);
                            }
                            catch (NumberFormatException exc) {
                                OperationExecutionJerseyClientInterceptor.LOGGER.warn("Invalid tradeId");
                            }
                        }
                        if (traceId != retTraceId) {
                            OperationExecutionJerseyClientInterceptor.LOGGER.error("TraceId in response header ({}) is different from that in request header ({})", (Object)retTraceId, (Object)traceId);
                        }
                        if ("null".equals(retSessionId = responseHeaderArray[1])) {
                            retSessionId = "<no-session-id>";
                        }
                        int retEOI = -1;
                        String retEOIStr = responseHeaderArray[2];
                        if (!"null".equals(retEOIStr)) {
                            try {
                                retEOI = Integer.parseInt(retEOIStr);
                                OperationExecutionJerseyClientInterceptor.CF_REGISTRY.storeThreadLocalEOI(retEOI);
                            }
                            catch (NumberFormatException exc) {
                                OperationExecutionJerseyClientInterceptor.LOGGER.warn("Invalid eoi", (Throwable)exc);
                            }
                        }
                    } else {
                        OperationExecutionJerseyClientInterceptor.LOGGER.debug("No monitoring data found in the response header from {}. Is it instrumented?", (Object)uri.toString());
                    }
                } else {
                    OperationExecutionJerseyClientInterceptor.LOGGER.debug("Response header from {} is null. Is it instrumented?", (Object)uri.toString());
                }
            }
            OperationExecutionJerseyClientInterceptor.CTRLINST.newMonitoringRecord(new OperationExecutionRecord(signature, sessionId, traceId, tin, tout, hostname, eoi, ess));
            if (entrypoint) {
                OperationExecutionJerseyClientInterceptor.CF_REGISTRY.unsetThreadLocalTraceId();
                OperationExecutionJerseyClientInterceptor.CF_REGISTRY.unsetThreadLocalEOI();
                OperationExecutionJerseyClientInterceptor.CF_REGISTRY.unsetThreadLocalESS();
                OperationExecutionJerseyClientInterceptor.SESSION_REGISTRY.unsetThreadLocalSessionId();
            } else {
                OperationExecutionJerseyClientInterceptor.CF_REGISTRY.storeThreadLocalESS(ess);
            }
        }
        return retval;
    }

    static {
        try {
            OperationExecutionJerseyClientInterceptor.ajc$perSingletonInstance = new OperationExecutionJerseyClientInterceptor();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static OperationExecutionJerseyClientInterceptor aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("kieker.monitoring.probe.aspectj.jersey.OperationExecutionJerseyClientInterceptor", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    public /* synthetic */ String ajc$superDispatch$kieker_monitoring_probe_aspectj_jersey_OperationExecutionJerseyClientInterceptor$signatureToLongString(Signature signature) {
        return super.signatureToLongString(signature);
    }
}

