/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.spring.flow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.ControlFlowRegistry;
import kieker.monitoring.core.registry.SessionRegistry;
import kieker.monitoring.probe.IMonitoringProbe;
import kieker.monitoring.timer.ITimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class RestInFilter
extends OncePerRequestFilter
implements IMonitoringProbe {
    private static final String SESSION_ID_ASYNC_TRACE = "NOSESSION-ASYNCIN";
    private static final IMonitoringController MONITORING_CTRL = MonitoringController.getInstance();
    private static final SessionRegistry SESSION_REGISTRY = SessionRegistry.INSTANCE;
    private static final ControlFlowRegistry CF_REGISTRY = ControlFlowRegistry.INSTANCE;
    private static final ITimeSource TIMESOURCE = MONITORING_CTRL.getTimeSource();
    private static final String VM_NAME = MONITORING_CTRL.getHostname();
    private static final Logger LOGGER = LoggerFactory.getLogger(RestInFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        int ess;
        int eoi;
        if (!MONITORING_CTRL.isMonitoringEnabled()) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        String signature = "public void com.example.intercept.in.RestInInterceptor.interceptIncoming" + httpServletRequest.getMethod() + "Request()";
        ArrayList requestRestHeader = Collections.list(httpServletRequest.getHeaders("KiekerTracingInfo"));
        final AtomicLong traceId = new AtomicLong(-1L);
        final AtomicReference<String> sessionId = new AtomicReference<String>(SESSION_REGISTRY.recallThreadLocalSessionId());
        if (requestRestHeader.isEmpty()) {
            LOGGER.debug("No monitoring data found in the incoming request header");
            traceId.set(CF_REGISTRY.getAndStoreUniqueThreadLocalTraceId());
            CF_REGISTRY.storeThreadLocalEOI(0);
            CF_REGISTRY.storeThreadLocalESS(1);
            eoi = 0;
            ess = 0;
        } else {
            String operationExecutionHeader = (String)requestRestHeader.get(0);
            LOGGER.info("Received request: {} with header = {}", (Object)httpServletRequest.getRequestURI(), (Object)((Object)requestRestHeader).toString());
            String[] headerArray = operationExecutionHeader.split(",");
            sessionId.set(headerArray[1]);
            if ("null".equals(sessionId.get())) {
                sessionId.set("<no-session-id>");
            }
            String eoiStr = headerArray[2];
            eoi = -1;
            try {
                eoi = 1 + Integer.parseInt(eoiStr);
            }
            catch (NumberFormatException exc) {
                LOGGER.warn("Invalid eoi", (Throwable)exc);
            }
            String essStr = headerArray[3];
            ess = -1;
            try {
                ess = Integer.parseInt(essStr);
            }
            catch (NumberFormatException exc) {
                LOGGER.warn("Invalid ess", (Throwable)exc);
            }
            String traceIdStr = headerArray[0];
            if (traceIdStr != null) {
                try {
                    traceId.set(Long.parseLong(traceIdStr));
                }
                catch (NumberFormatException exc) {
                    LOGGER.warn("Invalid trace id", (Throwable)exc);
                }
            } else {
                traceId.set(CF_REGISTRY.getUniqueTraceId());
                sessionId.set(SESSION_ID_ASYNC_TRACE);
                eoi = 0;
                ess = 0;
            }
            CF_REGISTRY.storeThreadLocalTraceId(traceId.get());
            CF_REGISTRY.storeThreadLocalEOI(eoi);
            CF_REGISTRY.storeThreadLocalESS(ess + 1);
            SESSION_REGISTRY.storeThreadLocalSessionId(sessionId.get());
        }
        long tin = TIMESOURCE.getTime();
        HttpServletResponseWrapper wrapper = new HttpServletResponseWrapper(httpServletResponse){

            public void setStatus(int sc) {
                super.setStatus(sc);
                this.handleStatus(sc);
            }

            public void setStatus(int sc, String sm) {
                super.setStatus(sc, sm);
                this.handleStatus(sc);
            }

            public void sendError(int sc, String msg) throws IOException {
                super.sendError(sc, msg);
                this.handleStatus(sc);
            }

            public void sendError(int sc) throws IOException {
                super.sendError(sc);
                this.handleStatus(sc);
            }

            private void handleStatus(int code) {
                this.addHeader("KiekerTracingInfo", traceId + "," + sessionId + "," + CF_REGISTRY.recallThreadLocalEOI() + "," + Integer.toString(CF_REGISTRY.recallThreadLocalESS()));
            }
        };
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)wrapper);
        }
        finally {
            SESSION_REGISTRY.unsetThreadLocalSessionId();
            long tout = TIMESOURCE.getTime();
            MONITORING_CTRL.newMonitoringRecord(new OperationExecutionRecord(signature, sessionId.get(), traceId.get(), tin, tout, VM_NAME, eoi, ess));
            CF_REGISTRY.unsetThreadLocalTraceId();
            CF_REGISTRY.unsetThreadLocalEOI();
            CF_REGISTRY.unsetThreadLocalESS();
        }
    }
}

