/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.mxbean;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.jvm.MemoryRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.signaturePattern.SignatureFactory;
import kieker.monitoring.sampler.mxbean.AbstractMXBeanSampler;

public class MemorySampler
extends AbstractMXBeanSampler {
    @Override
    protected IMonitoringRecord[] createNewMonitoringRecords(long timestamp, String hostname, String vmName, IMonitoringController monitoringCtr) {
        if (!monitoringCtr.isProbeActivated(SignatureFactory.createJVMMemSignature())) {
            return new IMonitoringRecord[0];
        }
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = memoryBean.getNonHeapMemoryUsage();
        return new IMonitoringRecord[]{new MemoryRecord(timestamp, hostname, vmName, heapMemoryUsage.getMax(), heapMemoryUsage.getUsed(), heapMemoryUsage.getCommitted(), heapMemoryUsage.getInit(), nonHeapMemoryUsage.getMax(), nonHeapMemoryUsage.getUsed(), nonHeapMemoryUsage.getCommitted(), nonHeapMemoryUsage.getInit(), memoryBean.getObjectPendingFinalizationCount())};
    }
}

