/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.timer;

import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kieker.common.configuration.Configuration;
import kieker.monitoring.timer.AbstractTimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemNanoTimer
extends AbstractTimeSource {
    public static final String CONFIG_OFFSET = SystemNanoTimer.class.getName() + ".offset";
    public static final String CONFIG_UNIT = SystemNanoTimer.class.getName() + ".unit";
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemNanoTimer.class);
    private final long offset;
    private final long clockdifference = System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    private final TimeUnit timeunit;

    public SystemNanoTimer(Configuration configuration) {
        super(configuration);
        this.offset = configuration.getStringProperty(CONFIG_OFFSET).length() == 0 ? System.nanoTime() : this.clockdifference + configuration.getLongProperty(CONFIG_OFFSET);
        int timeunitval = configuration.getIntProperty(CONFIG_UNIT);
        switch (timeunitval) {
            case 0: {
                this.timeunit = TimeUnit.NANOSECONDS;
                break;
            }
            case 1: {
                this.timeunit = TimeUnit.MICROSECONDS;
                break;
            }
            case 2: {
                this.timeunit = TimeUnit.MILLISECONDS;
                break;
            }
            case 3: {
                this.timeunit = TimeUnit.SECONDS;
                break;
            }
            default: {
                LOGGER.warn("Failed to determine value of {} (0, 1, 2, or 3 expected). Setting to 0=nanoseconds", (Object)CONFIG_UNIT);
                this.timeunit = TimeUnit.NANOSECONDS;
            }
        }
    }

    @Override
    public long getTime() {
        return this.timeunit.convert(System.nanoTime() - this.offset, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getOffset() {
        return this.timeunit.convert(this.offset - this.clockdifference, TimeUnit.NANOSECONDS);
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeunit;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Time in ").append(this.timeunit.toString().toLowerCase(Locale.ENGLISH)).append(" (with nanoseconds precision) since ").append(new Date(TimeUnit.NANOSECONDS.toMillis(this.offset - this.clockdifference)));
        return sb.toString();
    }
}

