/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer;

import java.util.Set;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;

public abstract class AbstractMonitoringWriter {
    protected final Configuration configuration;

    public AbstractMonitoringWriter(Configuration configuration) {
        this.configuration = configuration;
    }

    public abstract void onStarting();

    public abstract void writeMonitoringRecord(IMonitoringRecord var1);

    public abstract void onTerminating();

    public String toString() {
        StringBuilder sb = new StringBuilder(128).append("Writer: '").append(this.getClass().getName()).append("'\n\tConfiguration:");
        Set<String> keys = this.configuration.stringPropertyNames();
        if (keys.isEmpty()) {
            sb.append("\n\t\tNo Configuration");
        } else {
            for (String property : keys) {
                if (!property.startsWith(this.getClass().getName())) continue;
                sb.append("\n\t\t");
                sb.append(property);
                sb.append("='");
                sb.append(this.configuration.getStringProperty(property));
                sb.append('\'');
            }
        }
        return sb.toString();
    }
}

