/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.explorviz;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.flow.IObjectRecord;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.common.record.misc.HostApplicationMetaData;
import kieker.common.registry.IRegistryListener;
import kieker.common.registry.writer.IWriterRegistry;
import kieker.common.registry.writer.WriterRegistry;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.writer.AbstractMonitoringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplorVizTcpWriter
extends AbstractMonitoringWriter
implements IRegistryListener<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplorVizTcpWriter.class);
    private static final String PREFIX = ExplorVizTcpWriter.class.getName() + ".";
    public static final String CONFIG_HOSTNAME = PREFIX + "hostname";
    public static final String CONFIG_PORT = PREFIX + "port";
    public static final String CONFIG_BUFFERSIZE = PREFIX + "bufferSize";
    public static final String CONFIG_FLUSH = PREFIX + "flush";
    private static final byte HOST_APPLICATION_META_DATA_CLAZZ_ID = 0;
    private static final byte BEFORE_OPERATION_CLAZZ_ID = 1;
    private static final byte AFTER_FAILED_OPERATION_CLAZZ_ID = 2;
    private static final byte AFTER_OPERATION_CLAZZ_ID = 3;
    private static final byte STRING_REGISTRY_CLAZZ_ID = 4;
    private static final String EMPTY_STRING = "";
    private final boolean flush;
    private final ByteBuffer byteBuffer;
    private final WritableByteChannel socketChannel;
    private final IWriterRegistry<String> writerRegistry;

    public ExplorVizTcpWriter(Configuration configuration) throws IOException {
        super(configuration);
        String hostname = configuration.getStringProperty(CONFIG_HOSTNAME);
        int port = configuration.getIntProperty(CONFIG_PORT);
        int bufferSize = configuration.getIntProperty(CONFIG_BUFFERSIZE);
        this.flush = configuration.getBooleanProperty(CONFIG_FLUSH);
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.socketChannel = SocketChannel.open(new InetSocketAddress(hostname, port));
        LOGGER.info("Initialized socket channel for writing to {}:{}", (Object)hostname, (Object)port);
        this.writerRegistry = new WriterRegistry(this);
        this.writerRegistry.register(EMPTY_STRING);
    }

    @Override
    public void onStarting() {
        IMonitoringController monitoringController = MonitoringController.getInstance();
        try {
            HostApplicationMetaData record = new HostApplicationMetaData("Default System", InetAddress.getLocalHost().getHostAddress(), monitoringController.getHostname(), monitoringController.getName());
            this.writeMonitoringRecord(record);
        }
        catch (UnknownHostException e) {
            LOGGER.warn("An exception occurred", (Throwable)e);
        }
    }

    @Override
    public void writeMonitoringRecord(IMonitoringRecord record) {
        int recordSize = 0;
        if (record instanceof BeforeOperationEvent) {
            recordSize = 37;
        } else if (record instanceof AfterOperationFailedEvent) {
            recordSize = 25;
        } else if (record instanceof AfterOperationEvent) {
            recordSize = 21;
        } else if (record instanceof HostApplicationMetaData) {
            recordSize = 17;
        }
        ByteBuffer buffer = this.byteBuffer;
        if (recordSize > buffer.remaining()) {
            this.send(buffer);
        }
        this.convertKiekerToExplorViz(buffer, record);
        if (this.flush) {
            this.send(buffer);
        }
    }

    private void convertKiekerToExplorViz(ByteBuffer buffer, IMonitoringRecord kiekerRecord) {
        if (kiekerRecord instanceof BeforeOperationEvent) {
            BeforeOperationEvent kiekerBefore = (BeforeOperationEvent)kiekerRecord;
            this.writerRegistry.register(kiekerBefore.getOperationSignature());
            this.writerRegistry.register(kiekerBefore.getClassSignature());
            int opSigId = this.writerRegistry.getId(kiekerBefore.getOperationSignature());
            int classSigId = this.writerRegistry.getId(kiekerBefore.getClassSignature());
            int interfaceId = this.writerRegistry.getId(EMPTY_STRING);
            buffer.put((byte)1);
            buffer.putLong(kiekerBefore.getTimestamp());
            buffer.putLong(kiekerBefore.getTraceId());
            buffer.putInt(kiekerBefore.getOrderIndex());
            if (kiekerRecord instanceof IObjectRecord) {
                IObjectRecord iObjectRecord = (IObjectRecord)kiekerRecord;
                buffer.putInt(iObjectRecord.getObjectId());
            } else {
                buffer.putInt(0);
            }
            buffer.putInt(opSigId);
            buffer.putInt(classSigId);
            buffer.putInt(interfaceId);
        } else if (kiekerRecord instanceof AfterOperationFailedEvent) {
            AfterOperationFailedEvent kiekerAfterFailed = (AfterOperationFailedEvent)kiekerRecord;
            this.writerRegistry.register(kiekerAfterFailed.getCause());
            buffer.put((byte)2);
            buffer.putLong(kiekerAfterFailed.getTimestamp());
            buffer.putLong(kiekerAfterFailed.getTraceId());
            buffer.putInt(kiekerAfterFailed.getOrderIndex());
            buffer.putInt(this.writerRegistry.getId(kiekerAfterFailed.getCause()));
        } else if (kiekerRecord instanceof AfterOperationEvent) {
            AfterOperationEvent kiekerAfter = (AfterOperationEvent)kiekerRecord;
            buffer.put((byte)3);
            buffer.putLong(kiekerAfter.getTimestamp());
            buffer.putLong(kiekerAfter.getTraceId());
            buffer.putInt(kiekerAfter.getOrderIndex());
        } else if (kiekerRecord instanceof HostApplicationMetaData) {
            HostApplicationMetaData record = (HostApplicationMetaData)kiekerRecord;
            this.writerRegistry.register(record.getSystemName());
            this.writerRegistry.register(record.getIpAddress());
            this.writerRegistry.register(record.getHostname());
            this.writerRegistry.register(record.getApplicationName());
            buffer.put((byte)0);
            buffer.putInt(this.writerRegistry.getId(record.getSystemName()));
            buffer.putInt(this.writerRegistry.getId(record.getIpAddress()));
            buffer.putInt(this.writerRegistry.getId(record.getHostname()));
            buffer.putInt(this.writerRegistry.getId(record.getApplicationName()));
        }
    }

    @Override
    public void onNewRegistryEntry(String value, int id) {
        byte[] valueAsBytes = value.getBytes(StandardCharsets.UTF_8);
        this.byteBuffer.put((byte)4);
        this.byteBuffer.putInt(id);
        this.byteBuffer.putInt(valueAsBytes.length);
        this.byteBuffer.put(valueAsBytes);
        this.send(this.byteBuffer);
    }

    @Override
    public void onTerminating() {
        try {
            this.send(this.byteBuffer);
            this.socketChannel.close();
        }
        catch (IOException ex) {
            LOGGER.error("Error on closing connection.", (Throwable)ex);
        }
    }

    private void send(ByteBuffer buffer) {
        buffer.flip();
        try {
            while (buffer.hasRemaining()) {
                this.socketChannel.write(buffer);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error on sending registry entry.", (Throwable)e);
        }
        buffer.clear();
    }
}

