/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.io.TextValueSerializer;
import kieker.common.registry.writer.WriterRegistry;
import kieker.monitoring.writer.WriterUtil;
import kieker.monitoring.writer.compression.ICompressionFilter;
import kieker.monitoring.writer.filesystem.AbstractLogStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextLogStreamHandler
extends AbstractLogStreamHandler {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final Logger LOGGER = LoggerFactory.getLogger(TextLogStreamHandler.class);
    private final CharBuffer buffer;

    public TextLogStreamHandler(Boolean flushLogFile, Integer bufferSize, Charset charset, ICompressionFilter compressionFilter, WriterRegistry writerRegistry) {
        super(flushLogFile, bufferSize, charset, compressionFilter, writerRegistry);
        this.buffer = CharBuffer.allocate(bufferSize);
        this.serializer = TextValueSerializer.create(this.buffer);
        this.extension = ".dat";
    }

    @Override
    public void serialize(IMonitoringRecord record, int id) throws IOException {
        String header = String.format("$%d;%d", id, record.getLoggingTimestamp());
        this.buffer.put(header);
        record.serialize(this.serializer);
        this.buffer.put(LINE_SEPARATOR);
        this.buffer.flip();
        try {
            while (this.buffer.hasRemaining()) {
                this.numOfBytes += this.outputChannel.write(this.charset.encode(this.buffer));
            }
            ++this.numOfEntries;
            this.buffer.clear();
            if (this.flushLogFile) {
                this.serializedStream.flush();
            }
        }
        catch (IOException e) {
            LOGGER.error("Caught exception while writing to the channel.", (Throwable)e);
            WriterUtil.close(this.outputChannel, LOGGER);
        }
    }
}

