/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.influxdb;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.writer.AbstractMonitoringWriter;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBWriter
extends AbstractMonitoringWriter {
    public static final String CONFIG_PROPERTY_DB_URL = "databaseURL";
    public static final String CONFIG_PROPERTY_DB_PORT = "databasePort";
    public static final String CONFIG_PROPERTY_DB_USERNAME = "databaseUsername";
    public static final String CONFIG_PROPERTY_DB_PASSWORD = "databasePassword";
    public static final String CONFIG_PROPERTY_DB_NAME = "databaseName";
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluxDBWriter.class);
    private final String dbURL;
    private final int dbPort;
    private final String dbUsername;
    private final String dbPassword;
    private final String dbName;
    private volatile InfluxDB influxDB;
    private volatile int influxDBMajorVersion;
    private volatile boolean isConnected;

    public InfluxDBWriter(Configuration configuration) {
        super(configuration);
        this.dbURL = this.configuration.getStringProperty(CONFIG_PROPERTY_DB_URL);
        this.dbPort = this.configuration.getIntProperty(CONFIG_PROPERTY_DB_PORT);
        this.dbUsername = this.configuration.getStringProperty(CONFIG_PROPERTY_DB_USERNAME);
        this.dbPassword = this.configuration.getStringProperty(CONFIG_PROPERTY_DB_PASSWORD);
        this.dbName = this.configuration.getStringProperty(CONFIG_PROPERTY_DB_NAME);
        this.isConnected = false;
    }

    protected final void connectToInfluxDB() throws IOException {
        Pong pong;
        LOGGER.info("Connecting to database using the following parameters:");
        LOGGER.info("URL = {}", (Object)this.dbURL);
        LOGGER.info("Port = {}", (Object)this.dbPort);
        LOGGER.info("Username = {}", (Object)this.dbUsername);
        LOGGER.info("Password = {}", (Object)this.dbPassword);
        this.influxDB = InfluxDBFactory.connect((String)(this.dbURL + ":" + this.dbPort), (String)this.dbUsername, (String)this.dbPassword);
        if (!this.influxDB.isBatchEnabled()) {
            this.influxDB.enableBatch(2000, 500, TimeUnit.MILLISECONDS);
        }
        try {
            pong = this.influxDB.ping();
            LOGGER.info("Connected to InfluxDB");
        }
        catch (RuntimeException e) {
            throw new IOException("Cannot connect to InfluxDB with the following parameters:URL = " + this.dbURL + "; Port = " + this.dbPort + "; Username = " + this.dbUsername + "; Password = " + this.dbPassword, e);
        }
        String influxDBVersion = pong.getVersion();
        String[] splitVersion = influxDBVersion.split("\\.");
        this.influxDBMajorVersion = Integer.parseInt(splitVersion[0]);
        LOGGER.info("Version: {}", (Object)influxDBVersion);
        LOGGER.info("Response time: {}", (Object)pong.getResponseTime());
        List dbList = this.influxDB.describeDatabases();
        if (!dbList.contains(this.dbName)) {
            LOGGER.info("Database {} does not exist. Creating ...", (Object)this.dbName);
            this.influxDB.createDatabase(this.dbName);
            LOGGER.info("Done");
        }
        this.isConnected = true;
    }

    @Override
    public final void writeMonitoringRecord(IMonitoringRecord monitoringRecord) {
        if (!this.isConnected) {
            try {
                this.connectToInfluxDB();
            }
            catch (IOException e) {
                LOGGER.error("Cannot connect to InfluxDB. Dropping record.", (Throwable)e);
                return;
            }
        }
        String recordName = monitoringRecord.getClass().getSimpleName();
        long timestamp = monitoringRecord.getLoggingTimestamp();
        String[] propertyNames = monitoringRecord.getValueNames();
        Class<?>[] valueTypes = monitoringRecord.getValueTypes();
        String[] values = monitoringRecord.getValueNames();
        Method[] methods = monitoringRecord.getClass().getMethods();
        Point.Builder pointBuilder = Point.measurement((String)recordName);
        pointBuilder.time(timestamp, TimeUnit.NANOSECONDS);
        for (int i = 0; i < propertyNames.length; ++i) {
            String name = propertyNames[i];
            Class<?> type = valueTypes[i];
            Object value = this.invokeMethod(methods, type, name, monitoringRecord);
            if (type == Integer.TYPE) {
                pointBuilder.addField(name, ((Integer)value).intValue());
                continue;
            }
            if (type == Long.TYPE) {
                pointBuilder.addField(name, ((Long)value).longValue());
                continue;
            }
            if (type == Boolean.TYPE) {
                pointBuilder.addField(name, ((Boolean)value).booleanValue());
                continue;
            }
            if (type != String.class) continue;
            pointBuilder.addField(name, (String)value);
            pointBuilder.tag(name, (String)value);
        }
        Point point = pointBuilder.build();
        if (this.influxDBMajorVersion < 1) {
            this.influxDB.write(this.dbName, "default", point);
        } else {
            this.influxDB.write(this.dbName, "autogen", point);
        }
    }

    private Object invokeMethod(Method[] methods, Class<?> type, String name, Object monitoringRecord) {
        String prefix = type.equals(Boolean.class) ? "is" : "get";
        String methodName = prefix + name.substring(0, 1).toUpperCase(Locale.ROOT) + name.substring(1);
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            try {
                return method.invoke(monitoringRecord, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void onStarting() {
        try {
            this.connectToInfluxDB();
        }
        catch (IOException e) {
            LOGGER.error("Cannot connect to InfluxDB.", (Throwable)e);
        }
    }

    @Override
    public void onTerminating() {
        LOGGER.info("Closing database");
        this.influxDB.close();
        LOGGER.info("Closing database done");
    }
}

