/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.serializer;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.io.BinaryValueSerializer;
import kieker.common.registry.writer.IWriterRegistry;
import kieker.common.util.dataformat.FormatIdentifier;
import kieker.common.util.dataformat.VariableLengthEncoding;
import kieker.monitoring.writer.serializer.AbstractContainerFormatSerializer;
import kieker.monitoring.writer.serializer.SerializerStringRegistry;

public class BinarySerializer
extends AbstractContainerFormatSerializer {
    public static final int FORMAT_IDENTIFIER = FormatIdentifier.DEFAULT_BINARY_FORMAT.getIdentifierValue();
    private static final String ENCODING_NAME = "UTF-8";
    private static final Charset CHARSET = Charset.forName("UTF-8");

    public BinarySerializer(Configuration configuration) {
        super(configuration);
    }

    @Override
    protected int getFormatIdentifier() {
        return FORMAT_IDENTIFIER;
    }

    @Override
    protected int writeRecords(Collection<IMonitoringRecord> records, ByteBuffer buffer) {
        SerializerStringRegistry stringRegistry = new SerializerStringRegistry();
        int recordDataSize = this.encodeRecords(records, buffer, stringRegistry);
        int stringDataSize = this.encodeStringRegistry(stringRegistry, buffer);
        buffer.putInt(recordDataSize);
        return recordDataSize + stringDataSize + 4;
    }

    private int encodeRecords(Collection<IMonitoringRecord> records, ByteBuffer buffer, IWriterRegistry<String> writerRegistry) {
        int offsetBefore = buffer.position();
        for (IMonitoringRecord record : records) {
            String typeName = record.getClass().getName();
            int typeNameId = writerRegistry.getId(typeName);
            buffer.putInt(typeNameId);
            buffer.putLong(record.getLoggingTimestamp());
            record.serialize(BinaryValueSerializer.create(buffer, writerRegistry));
        }
        int offsetAfter = buffer.position();
        return offsetAfter - offsetBefore;
    }

    private int encodeStringRegistry(SerializerStringRegistry registry, ByteBuffer buffer) {
        List<String> allStrings = registry.getValues();
        int offsetBefore = buffer.position();
        VariableLengthEncoding.encodeInt(allStrings.size(), buffer);
        for (String string : allStrings) {
            byte[] stringBytes = string.getBytes(CHARSET);
            int length = stringBytes.length;
            VariableLengthEncoding.encodeInt(length, buffer);
            buffer.put(stringBytes);
        }
        int offsetAfter = buffer.position();
        return offsetAfter - offsetBefore;
    }

    @Override
    public void onInitialization() {
    }

    @Override
    public void onTermination() {
    }
}

