/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.common;

import com.beust.jcommander.JCommander;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParameterEvaluationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterEvaluationUtils.class);

    private ParameterEvaluationUtils() {
    }

    public static boolean checkDirectory(File location, String label, JCommander commander) {
        if (location == null) {
            LOGGER.error("{} path not specified.", (Object)label);
            commander.usage();
            return false;
        }
        try {
            if (!location.exists()) {
                LOGGER.error("{} path {} does not exist.", (Object)label, (Object)location.getCanonicalPath());
                commander.usage();
                return false;
            }
            if (!location.isDirectory()) {
                LOGGER.error("{} path {} is not a directory.", (Object)label, (Object)location.getCanonicalPath());
                commander.usage();
                return false;
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("{} path {} cannot be checked. Cause {}", new Object[]{label, location, e.getLocalizedMessage()});
            return false;
        }
    }

    public static boolean isFileReadable(File file, String label, JCommander commander) {
        if (file == null) {
            LOGGER.error("{} path not specified.", (Object)label);
            commander.usage();
            return false;
        }
        try {
            if (!file.exists()) {
                LOGGER.error("{} {} does not exist.", (Object)label, (Object)file.getCanonicalPath());
                return false;
            }
            if (!file.isFile()) {
                LOGGER.error("{} {} is not a file.", (Object)label, (Object)file.getCanonicalPath());
                return false;
            }
            if (!file.canRead()) {
                LOGGER.error("{} {} cannot be read.", (Object)label, (Object)file.getCanonicalPath());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("{} {} cannot be checked. Cause {}", new Object[]{label, file, e.getLocalizedMessage()});
            return false;
        }
    }

    public static URL createURL(String urlString, String label) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            LOGGER.error("{} Malformend URL {}", (Object)label, (Object)urlString);
            return null;
        }
    }
}

