/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.source;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kieker.analysis.source.ISourceCompositeStage;
import kieker.analysis.source.file.DirectoryReaderStage;
import kieker.analysis.source.file.DirectoryScannerStage;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import teetime.framework.CompositeStage;
import teetime.framework.OutputPort;

public class LogsReaderCompositeStage
extends CompositeStage
implements ISourceCompositeStage {
    public static final String PREFIX = LogsReaderCompositeStage.class.getCanonicalName() + ".";
    public static final String LOG_DIRECTORIES = PREFIX + "logDirectories";
    public static final String DATA_BUFFER_SIZE = PREFIX + "bufferSize";
    public static final String VERBOSE = PREFIX + "verbose";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final DirectoryScannerStage directoryScannerStage;
    private final DirectoryReaderStage directoryReaderStage;

    public LogsReaderCompositeStage(Configuration configuration) {
        String[] directoryNames = configuration.getStringArrayProperty(LOG_DIRECTORIES, ":");
        ArrayList<File> directories = new ArrayList<File>(directoryNames.length);
        for (String name : directoryNames) {
            directories.add(new File(name));
        }
        int dataBufferSize = configuration.getIntProperty(DATA_BUFFER_SIZE, 8192);
        boolean verbose = configuration.getBooleanProperty(VERBOSE, false);
        this.directoryScannerStage = new DirectoryScannerStage(directories);
        this.directoryReaderStage = new DirectoryReaderStage(verbose, dataBufferSize);
        this.connectPorts(this.directoryScannerStage.getOutputPort(), this.directoryReaderStage.getInputPort());
    }

    public LogsReaderCompositeStage(List<File> directories, boolean verbose, Integer dataBufferSize) {
        this.directoryScannerStage = new DirectoryScannerStage(directories);
        this.directoryReaderStage = new DirectoryReaderStage(verbose, dataBufferSize == null ? 8192 : dataBufferSize);
        this.connectPorts(this.directoryScannerStage.getOutputPort(), this.directoryReaderStage.getInputPort());
    }

    @Override
    public OutputPort<IMonitoringRecord> getOutputPort() {
        return this.directoryReaderStage.getOutputPort();
    }
}

