/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.traceFilter;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.tools.trace.analysis.filter.AbstractExecutionTraceProcessingFilter;
import kieker.tools.trace.analysis.filter.traceFilter.AbstractExecutionTraceHashContainer;
import kieker.tools.trace.analysis.filter.traceFilter.ExecutionTraceHashContainerAllocationEquivalence;
import kieker.tools.trace.analysis.filter.traceFilter.ExecutionTraceHashContainerAssemblyEquivalence;
import kieker.tools.trace.analysis.filter.traceReconstruction.InvalidTraceException;
import kieker.tools.trace.analysis.systemModel.ExecutionTrace;
import kieker.tools.trace.analysis.systemModel.MessageTrace;
import kieker.tools.trace.analysis.systemModel.repository.SystemModelRepository;

@Deprecated
@Plugin(description="Puts the incoming traces into equivalence classes", outputPorts={@OutputPort(name="messageTraceRepresentatives", description="Message Traces", eventTypes={MessageTrace.class}), @OutputPort(name="executionTraceRepresentatives", description="Execution Traces", eventTypes={ExecutionTrace.class})}, repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="equivalenceMode", description="The trace equivalence criteria: DISABLED (default value), ASSEMBLY (assembly-level equivalence), or ALLOCATION (allocation-level equivalence)", defaultValue="DISABLED")})
public class TraceEquivalenceClassFilter
extends AbstractExecutionTraceProcessingFilter {
    public static final String INPUT_PORT_NAME_EXECUTION_TRACE = "executionTraces";
    public static final String OUTPUT_PORT_NAME_MESSAGE_TRACE_REPRESENTATIVES = "messageTraceRepresentatives";
    public static final String OUTPUT_PORT_NAME_EXECUTION_TRACE_REPRESENTATIVES = "executionTraceRepresentatives";
    public static final String CONFIG_PROPERTY_NAME_EQUIVALENCE_MODE = "equivalenceMode";
    public static final TraceEquivalenceClassModes DEFAULT_EQUIVALENCE_MODE = TraceEquivalenceClassModes.DISABLED;
    private final TraceEquivalenceClassModes equivalenceMode;
    private final ConcurrentMap<AbstractExecutionTraceHashContainer, AtomicInteger> eTracesEquivClassesMap = new ConcurrentHashMap<AbstractExecutionTraceHashContainer, AtomicInteger>();

    public TraceEquivalenceClassFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.equivalenceMode = this.extractTraceEquivalenceClassMode(this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_EQUIVALENCE_MODE));
    }

    private TraceEquivalenceClassModes extractTraceEquivalenceClassMode(String traceEquivalenceCallModeString) {
        TraceEquivalenceClassModes extractedEquivalenceMode;
        try {
            extractedEquivalenceMode = TraceEquivalenceClassModes.valueOf(traceEquivalenceCallModeString);
        }
        catch (IllegalArgumentException exc) {
            this.logger.error("Error extracting enum value from String: '{}'", (Object)traceEquivalenceCallModeString, (Object)exc);
            extractedEquivalenceMode = DEFAULT_EQUIVALENCE_MODE;
        }
        return extractedEquivalenceMode;
    }

    @InputPort(name="executionTraces", description="Execution traces", eventTypes={ExecutionTrace.class})
    public void newExecutionTrace(ExecutionTrace et) {
        try {
            if (this.equivalenceMode == TraceEquivalenceClassModes.DISABLED) {
                super.deliver(OUTPUT_PORT_NAME_EXECUTION_TRACE_REPRESENTATIVES, et);
                super.deliver(OUTPUT_PORT_NAME_MESSAGE_TRACE_REPRESENTATIVES, et.toMessageTrace(SystemModelRepository.ROOT_EXECUTION));
            } else {
                AbstractExecutionTraceHashContainer polledTraceHashContainer;
                if (this.equivalenceMode == TraceEquivalenceClassModes.ASSEMBLY) {
                    polledTraceHashContainer = new ExecutionTraceHashContainerAssemblyEquivalence(et);
                } else if (this.equivalenceMode == TraceEquivalenceClassModes.ALLOCATION) {
                    polledTraceHashContainer = new ExecutionTraceHashContainerAllocationEquivalence(et);
                } else {
                    this.logger.error("Invalid trace equivalence mode: {}", (Object)this.equivalenceMode);
                    this.reportError(et.getTraceId());
                    return;
                }
                AtomicInteger numOccurences = (AtomicInteger)this.eTracesEquivClassesMap.get(polledTraceHashContainer);
                if (numOccurences == null) {
                    numOccurences = new AtomicInteger(1);
                    this.eTracesEquivClassesMap.put(polledTraceHashContainer, numOccurences);
                    super.deliver(OUTPUT_PORT_NAME_EXECUTION_TRACE_REPRESENTATIVES, et);
                    super.deliver(OUTPUT_PORT_NAME_MESSAGE_TRACE_REPRESENTATIVES, et.toMessageTrace(SystemModelRepository.ROOT_EXECUTION));
                } else {
                    numOccurences.incrementAndGet();
                }
            }
            this.reportSuccess(et.getTraceId());
        }
        catch (InvalidTraceException ex) {
            this.logger.error("InvalidTraceException: {}", (Object)ex.getMessage());
            this.reportError(et.getTraceId());
        }
    }

    public ConcurrentMap<ExecutionTrace, Integer> getEquivalenceClassMap() {
        ConcurrentHashMap<ExecutionTrace, Integer> map = new ConcurrentHashMap<ExecutionTrace, Integer>();
        for (Map.Entry entry : this.eTracesEquivClassesMap.entrySet()) {
            map.put(((AbstractExecutionTraceHashContainer)entry.getKey()).getExecutionTrace(), ((AtomicInteger)entry.getValue()).intValue());
        }
        return map;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = super.getCurrentConfiguration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_EQUIVALENCE_MODE, this.equivalenceMode.toString());
        return configuration;
    }

    public static enum TraceEquivalenceClassModes {
        DISABLED,
        ASSEMBLY,
        ALLOCATION;

    }
}

