/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace.dependency.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.model.system.model.AllocationComponent;
import kieker.model.system.model.ExecutionContainer;
import kieker.tools.trace.analysis.filter.visualization.AbstractGraphFormatter;
import kieker.tools.trace.analysis.filter.visualization.util.dot.DotFactory;
import kieker.visualization.trace.dependency.graph.AbstractComponentDependencyGraphFormatter;
import kieker.visualization.trace.dependency.graph.AbstractDependencyGraphFormatter;
import kieker.visualization.trace.dependency.graph.AbstractDependencyGraphFormatterVisitor;
import kieker.visualization.trace.dependency.graph.ComponentAllocationDependencyGraph;
import kieker.visualization.trace.dependency.graph.DependencyGraphNode;

public class ComponentAllocationDependencyGraphFormatter
extends AbstractComponentDependencyGraphFormatter<ComponentAllocationDependencyGraph> {
    private static final String DEFAULT_FILE_NAME = "deploymentComponentDependencyGraph.dot";

    private static ConcurrentMap<ExecutionContainer, List<DependencyGraphNode<AllocationComponent>>> groupNodesByComponent(ComponentAllocationDependencyGraph graph) {
        ConcurrentHashMap<ExecutionContainer, List<DependencyGraphNode<AllocationComponent>>> nodeMap = new ConcurrentHashMap<ExecutionContainer, List<DependencyGraphNode<AllocationComponent>>>();
        for (DependencyGraphNode node : graph.getNodes()) {
            ExecutionContainer container = ((AllocationComponent)node.getEntity()).getExecutionContainer();
            ArrayList nodes = (ArrayList)nodeMap.get(container);
            if (nodes == null) {
                nodes = new ArrayList();
                nodeMap.put(container, nodes);
            }
            nodes.add(node);
        }
        return nodeMap;
    }

    private void handleContainerEntry(Map.Entry<ExecutionContainer, List<DependencyGraphNode<AllocationComponent>>> entry, StringBuilder builder, boolean useShortLabels) {
        ExecutionContainer container = entry.getKey();
        if (container.isRootContainer()) {
            builder.append((CharSequence)DotFactory.createNode("", AbstractDependencyGraphFormatter.createNodeId(0), "'Entry'", "none", null, null, null, null, 0.0, null, null, null));
        } else {
            builder.append((CharSequence)DotFactory.createCluster("", AbstractDependencyGraphFormatter.createContainerId(container), "<<execution container>>\\n" + container.getName(), "box", "filled", null, "white", null, 0.0, null));
            for (DependencyGraphNode<AllocationComponent> node : entry.getValue()) {
                builder.append((CharSequence)DotFactory.createNode("", AbstractDependencyGraphFormatter.createNodeId(node), AbstractComponentDependencyGraphFormatter.createComponentNodeLabel(node, useShortLabels, "<<deployment component>>"), "box", "filled", AbstractGraphFormatter.getDotRepresentation(node.getColor()), AbstractDependencyGraphFormatter.getNodeFillColor(node), null, 0.0, null, null, node.getDescription()));
            }
            builder.append("}\n");
        }
    }

    @Override
    protected String formatDependencyGraph(ComponentAllocationDependencyGraph graph, boolean includeWeights, boolean useShortLabels, boolean plotLoops) {
        StringBuilder builder = new StringBuilder();
        this.appendGraphHeader(builder);
        ConcurrentMap<ExecutionContainer, List<DependencyGraphNode<AllocationComponent>>> nodeMap = ComponentAllocationDependencyGraphFormatter.groupNodesByComponent(graph);
        for (Map.Entry<ExecutionContainer, List<DependencyGraphNode<AllocationComponent>>> entry : nodeMap.entrySet()) {
            this.handleContainerEntry(entry, builder, useShortLabels);
        }
        graph.traverseWithVerticesFirst(new EdgeFormattingVisitor(builder, includeWeights, plotLoops, useShortLabels));
        this.appendGraphFooter(builder);
        return builder.toString();
    }

    @Override
    public String getDefaultFileName() {
        return DEFAULT_FILE_NAME;
    }

    private static class EdgeFormattingVisitor
    extends AbstractDependencyGraphFormatterVisitor<AllocationComponent> {
        public EdgeFormattingVisitor(StringBuilder builder, boolean includeWeights, boolean plotLoops, boolean useShortLabels) {
            super(builder, includeWeights, plotLoops, useShortLabels);
        }

        @Override
        public void visitVertex(DependencyGraphNode<AllocationComponent> vertex) {
        }
    }
}

