/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace.dependency.graph;

import java.util.concurrent.TimeUnit;
import kieker.model.repository.AssemblyRepository;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.AbstractMessage;
import kieker.model.system.model.AssemblyComponent;
import kieker.model.system.model.MessageTrace;
import kieker.model.system.model.SynchronousReplyMessage;
import kieker.visualization.trace.dependency.graph.AbstractDependencyGraph;
import kieker.visualization.trace.dependency.graph.AbstractDependencyGraphFilter;
import kieker.visualization.trace.dependency.graph.ComponentAssemblyDependencyGraph;
import kieker.visualization.trace.dependency.graph.DependencyGraphNode;

public class ComponentDependencyGraphAssemblyFilter
extends AbstractDependencyGraphFilter<AssemblyComponent> {
    public ComponentDependencyGraphAssemblyFilter(SystemModelRepository repository, TimeUnit timeUnit) {
        super(repository, timeUnit, new ComponentAssemblyDependencyGraph(AssemblyRepository.ROOT_ASSEMBLY_COMPONENT));
    }

    @Override
    protected void execute(MessageTrace t) throws Exception {
        for (AbstractMessage m : t.getSequenceAsVector()) {
            if (m instanceof SynchronousReplyMessage) continue;
            AssemblyComponent senderComponent = m.getSendingExecution().getAllocationComponent().getAssemblyComponent();
            AssemblyComponent receiverComponent = m.getReceivingExecution().getAllocationComponent().getAssemblyComponent();
            DependencyGraphNode<Object> senderNode = ((AbstractDependencyGraph)this.getGraph()).getNode(senderComponent.getId());
            DependencyGraphNode<Object> receiverNode = ((AbstractDependencyGraph)this.getGraph()).getNode(receiverComponent.getId());
            if (senderNode == null) {
                senderNode = new DependencyGraphNode<AssemblyComponent>(senderComponent.getId(), senderComponent, t.getTraceInformation(), this.getOriginRetentionPolicy());
                if (m.getSendingExecution().isAssumed()) {
                    senderNode.setAssumed();
                }
                ((AbstractDependencyGraph)this.getGraph()).addNode(senderNode.getId(), senderNode);
            } else {
                this.handleOrigin(senderNode, t.getTraceInformation());
            }
            if (receiverNode == null) {
                receiverNode = new DependencyGraphNode<AssemblyComponent>(receiverComponent.getId(), receiverComponent, t.getTraceInformation(), this.getOriginRetentionPolicy());
                if (m.getReceivingExecution().isAssumed()) {
                    receiverNode.setAssumed();
                }
                ((AbstractDependencyGraph)this.getGraph()).addNode(receiverNode.getId(), receiverNode);
            } else {
                this.handleOrigin(receiverNode, t.getTraceInformation());
            }
            boolean assumed = this.isDependencyAssumed(senderNode, receiverNode);
            senderNode.addOutgoingDependency(receiverNode, assumed, t.getTraceInformation(), this.getOriginRetentionPolicy());
            receiverNode.addIncomingDependency(senderNode, assumed, t.getTraceInformation(), this.getOriginRetentionPolicy());
            this.invokeDecorators(m, senderNode, receiverNode);
        }
        this.reportSuccess(t.getTraceId());
    }

    protected void onTerminating() {
        this.logger.debug("Terminating {}", (Object)this.getClass().getCanonicalName());
        this.getOutputPort().send(this.getGraph());
        super.onTerminating();
    }
}

