/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace.descriptions;

import java.util.Map;
import kieker.model.system.model.ISystemModelElement;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractEdge;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractGraph;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractGraphElement;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractPayloadedVertex;
import kieker.tools.trace.analysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.trace.analysis.filter.visualization.graph.NoOriginRetentionPolicy;
import kieker.tools.trace.analysis.repository.DescriptionRepository;
import kieker.visualization.trace.AbstractGraphFilter;

public class DescriptionDecoratorFilter<V extends AbstractPayloadedVertex<V, E, O, ISystemModelElement>, E extends AbstractEdge<V, E, O>, O>
extends AbstractGraphFilter<AbstractGraph<V, E, O>, V, E, O>
implements AbstractGraph.IGraphVisitor<V, E> {
    public static final String DESCRIPTION_REPOSITORY_PORT_NAME = "descriptionRepository";
    private final Map<String, String> decorationsMap;

    public DescriptionDecoratorFilter(DescriptionRepository repository) {
        this.decorationsMap = repository.getDescriptionMap();
    }

    @Override
    public void visitVertex(V vertex) {
        ISystemModelElement element = (ISystemModelElement)((AbstractPayloadedVertex)vertex).getPayload();
        if (element == null) {
            return;
        }
        String decoration = this.decorationsMap.get(element.getIdentifier());
        ((AbstractGraphElement)vertex).setDescription(decoration);
    }

    @Override
    public void visitEdge(E edge) {
    }

    @Override
    protected AbstractGraph<V, E, O> performConcreteGraphProcessing(AbstractGraph<V, E, O> graph) {
        graph.traverse(this);
        return graph;
    }

    @Override
    protected IOriginRetentionPolicy getDesiredOriginRetentionPolicy() {
        return NoOriginRetentionPolicy.createInstance();
    }
}

