/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kieker.analysis.AnalysisController;
import kieker.analysis.IAnalysisController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalysisControllerThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalysisControllerThread.class);
    private final IAnalysisController analysisController;
    private final CountDownLatch terminationLatch = new CountDownLatch(1);

    public AnalysisControllerThread(IAnalysisController analysisController) {
        this.analysisController = analysisController;
    }

    @Override
    public synchronized void start() {
        super.start();
        if (this.analysisController instanceof AnalysisController) {
            ((AnalysisController)this.analysisController).awaitInitialization();
        }
    }

    @Override
    public void run() {
        try {
            this.analysisController.run();
            this.terminationLatch.countDown();
        }
        catch (Exception ex) {
            LOGGER.error("Error running AnalysisController.", ex);
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.terminationLatch.await(timeout, unit);
    }

    public void awaitTermination() throws InterruptedException {
        this.terminationLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        AnalysisControllerThread analysisControllerThread = this;
        synchronized (analysisControllerThread) {
            this.analysisController.terminate();
        }
    }
}

