/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis;

import java.io.File;
import java.nio.file.Path;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;
import kieker.analysis.graph.dependency.DependencyGraphCreatorStage;
import kieker.analysis.graph.dependency.DeploymentLevelOperationDependencyGraphBuilderFactory;
import kieker.analysis.graph.dependency.dot.DotExportConfigurationFactory;
import kieker.analysis.graph.dependency.vertextypes.IVertexTypeMapper;
import kieker.analysis.graph.export.dot.DotExportConfiguration;
import kieker.analysis.graph.export.dot.DotFileWriterStage;
import kieker.analysis.signature.NameBuilder;
import kieker.analysis.signature.SignatureExtractor;
import kieker.analysis.source.file.DirectoryReaderStage;
import kieker.analysis.source.file.DirectoryScannerStage;
import kieker.analysis.stage.model.CallEvent2OperationCallStage;
import kieker.analysis.stage.model.ExecutionModelAssembler;
import kieker.analysis.stage.model.ExecutionModelAssemblerStage;
import kieker.analysis.stage.model.ModelObjectFromOperationCallAccessorUtils;
import kieker.analysis.stage.model.ModelRepository;
import kieker.analysis.stage.model.OperationAndCallGeneratorStage;
import kieker.analysis.stage.model.OperationPresentInModelEventReleaseControlStage;
import kieker.analysis.stage.model.StaticModelsAssemblerStage;
import kieker.analysis.stage.model.data.OperationCallDurationEvent;
import kieker.analysis.statistics.CallStatisticsStage;
import kieker.analysis.statistics.FullResponseTimeStatisticsStage;
import kieker.analysis.trace.graph.TraceToGraphTransformerStage;
import kieker.analysis.trace.graph.dot.DotTraceGraphFileWriterStage;
import kieker.analysis.trace.reconstruction.FlowRecordTraceReconstructionStage;
import kieker.analysis.trace.reconstruction.TraceStatisticsDecoratorStage;
import kieker.analysis.util.stage.AllowedRecordsFilter;
import kieker.analysis.util.stage.trigger.TriggerOnTerminationStage;
import kieker.model.analysismodel.assembly.AssemblyFactory;
import kieker.model.analysismodel.assembly.AssemblyModel;
import kieker.model.analysismodel.deployment.DeploymentFactory;
import kieker.model.analysismodel.deployment.DeploymentModel;
import kieker.model.analysismodel.execution.ExecutionFactory;
import kieker.model.analysismodel.execution.ExecutionModel;
import kieker.model.analysismodel.sources.SourceModel;
import kieker.model.analysismodel.sources.SourcesFactory;
import kieker.model.analysismodel.statistics.StatisticsFactory;
import kieker.model.analysismodel.statistics.StatisticsModel;
import kieker.model.analysismodel.type.TypeFactory;
import kieker.model.analysismodel.type.TypeModel;
import org.eclipse.emf.ecore.EObject;
import teetime.framework.Configuration;
import teetime.stage.basic.distributor.Distributor;
import teetime.stage.basic.distributor.strategy.CopyByReferenceStrategy;
import teetime.stage.basic.distributor.strategy.IDistributorStrategy;

public class ExampleConfiguration
extends Configuration {
    private static final String DYNAMIC_SOURCE = "dynamic-source";
    private final TypeModel typeModel = TypeFactory.eINSTANCE.createTypeModel();
    private final AssemblyModel assemblyModel = AssemblyFactory.eINSTANCE.createAssemblyModel();
    private final DeploymentModel deploymentModel = DeploymentFactory.eINSTANCE.createDeploymentModel();
    private final ExecutionModel executionModel = ExecutionFactory.eINSTANCE.createExecutionModel();
    private final StatisticsModel statisticsModel = StatisticsFactory.eINSTANCE.createStatisticsModel();
    private final SourceModel sourceModel = SourcesFactory.eINSTANCE.createSourceModel();
    private final SignatureExtractor signatureExtractor = SignatureExtractor.forJava();

    public ExampleConfiguration(File importDirectory, Path exportDirectory) {
        ChronoUnit timeUnitOfRecods = ChronoUnit.NANOS;
        Function<OperationCallDurationEvent, EObject> statisticsObjectAccesor = ModelObjectFromOperationCallAccessorUtils.DEPLOYED_OPERATION;
        DeploymentLevelOperationDependencyGraphBuilderFactory deploymentGraphBuilderFactory = new DeploymentLevelOperationDependencyGraphBuilderFactory();
        DotExportConfiguration dependencyGraphDotExportConfiguration = new DotExportConfigurationFactory(NameBuilder.forJavaShortOperations(), IVertexTypeMapper.TO_STRING).createForDeploymentLevelOperationDependencyGraph();
        ModelRepository repository = new ModelRepository("Example");
        repository.register(TypeModel.class, this.typeModel);
        repository.register(AssemblyModel.class, this.assemblyModel);
        repository.register(DeploymentModel.class, this.deploymentModel);
        repository.register(ExecutionModel.class, this.executionModel);
        repository.register(StatisticsModel.class, this.statisticsModel);
        repository.register(SourceModel.class, this.sourceModel);
        DirectoryScannerStage directoryScannerStage = new DirectoryScannerStage(importDirectory);
        DirectoryReaderStage directoryReaderStage = new DirectoryReaderStage(false, 80860);
        AllowedRecordsFilter allowedRecordsFilter = new AllowedRecordsFilter();
        Distributor flowRecordDistributor = new Distributor((IDistributorStrategy)new CopyByReferenceStrategy());
        OperationAndCallGeneratorStage operationAndCallGeneratorStage = new OperationAndCallGeneratorStage(true);
        StaticModelsAssemblerStage staticModelsAssemblerStage = new StaticModelsAssemblerStage(this.typeModel, this.assemblyModel, this.deploymentModel, this.sourceModel, DYNAMIC_SOURCE, this.signatureExtractor);
        OperationPresentInModelEventReleaseControlStage operationPresentInModelEventReleaseControlStage = new OperationPresentInModelEventReleaseControlStage(this.deploymentModel);
        CallEvent2OperationCallStage callEvent2OperationCallStage = new CallEvent2OperationCallStage(repository.getModel(DeploymentModel.class));
        ExecutionModelAssemblerStage executionModelAssemblerStage = new ExecutionModelAssemblerStage(new ExecutionModelAssembler(this.executionModel, this.sourceModel, DYNAMIC_SOURCE));
        CallStatisticsStage callStatisticsStage = new CallStatisticsStage(this.statisticsModel, this.executionModel);
        FlowRecordTraceReconstructionStage traceReconstructor = new FlowRecordTraceReconstructionStage(this.deploymentModel, timeUnitOfRecods);
        TraceStatisticsDecoratorStage traceStatisticsDecorator = new TraceStatisticsDecoratorStage();
        FullResponseTimeStatisticsStage fullStatisticsDecorator = new FullResponseTimeStatisticsStage(this.statisticsModel, statisticsObjectAccesor);
        TraceToGraphTransformerStage traceToGraphTransformer = new TraceToGraphTransformerStage();
        DotTraceGraphFileWriterStage dotTraceGraphFileWriter = DotTraceGraphFileWriterStage.create(exportDirectory);
        TriggerOnTerminationStage onTerminationTrigger = new TriggerOnTerminationStage();
        DependencyGraphCreatorStage dependencyGraphCreator = new DependencyGraphCreatorStage(repository, deploymentGraphBuilderFactory);
        DotFileWriterStage dotDepGraphFileWriter = new DotFileWriterStage(exportDirectory, dependencyGraphDotExportConfiguration);
        super.connectPorts(directoryScannerStage.getOutputPort(), directoryReaderStage.getInputPort());
        super.connectPorts(directoryReaderStage.getOutputPort(), allowedRecordsFilter.getInputPort());
        super.connectPorts(allowedRecordsFilter.getOutputPort(), flowRecordDistributor.getInputPort());
        super.connectPorts(flowRecordDistributor.getNewOutputPort(), operationAndCallGeneratorStage.getInputPort());
        super.connectPorts(operationAndCallGeneratorStage.getOperationOutputPort(), staticModelsAssemblerStage.getInputPort());
        super.connectPorts(flowRecordDistributor.getNewOutputPort(), operationPresentInModelEventReleaseControlStage.getInputPort());
        super.connectPorts(operationPresentInModelEventReleaseControlStage.getOutputPort(), traceReconstructor.getInputPort());
        super.connectPorts(traceReconstructor.getOutputPort(), traceStatisticsDecorator.getInputPort());
        super.connectPorts(traceStatisticsDecorator.getOutputPort(), traceToGraphTransformer.getInputPort());
        super.connectPorts(traceToGraphTransformer.getOutputPort(), dotTraceGraphFileWriter.getInputPort());
        super.connectPorts(operationAndCallGeneratorStage.getCallOutputPort(), callEvent2OperationCallStage.getInputPort());
        super.connectPorts(callEvent2OperationCallStage.getOutputPort(), executionModelAssemblerStage.getInputPort());
        super.connectPorts(executionModelAssemblerStage.getOutputPort(), callStatisticsStage.getInputPort());
        super.connectPorts(callStatisticsStage.getOutputPort(), fullStatisticsDecorator.getInputPort());
        super.connectPorts(fullStatisticsDecorator.getOutputPort(), onTerminationTrigger.getInputPort());
        super.connectPorts(onTerminationTrigger.getOutputPort(), dependencyGraphCreator.getInputPort());
        super.connectPorts(dependencyGraphCreator.getOutputPort(), dotDepGraphFileWriter.getInputPort());
    }

    public DeploymentModel getDeploymentModel() {
        return this.deploymentModel;
    }

    public ExecutionModel getExecutionModel() {
        return this.executionModel;
    }

    public StatisticsModel getStatisticsModel() {
        return this.statisticsModel;
    }
}

