/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.graph.dependency;

import kieker.analysis.graph.IGraph;
import kieker.analysis.graph.IVertex;
import kieker.analysis.graph.dependency.AbstractDependencyGraphBuilder;
import kieker.analysis.graph.dependency.vertextypes.VertexType;
import kieker.analysis.stage.model.ModelRepository;
import kieker.model.analysismodel.deployment.DeployedComponent;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.deployment.DeploymentContext;

public class DeploymentLevelOperationDependencyGraphBuilder
extends AbstractDependencyGraphBuilder {
    public DeploymentLevelOperationDependencyGraphBuilder(ModelRepository repository) {
        super(repository);
    }

    @Override
    protected IVertex addVertex(DeployedOperation deployedOperation) {
        DeployedOperation operation = deployedOperation;
        DeployedComponent component = operation.getComponent();
        DeploymentContext context = component.getDeploymentContext();
        int contextId = this.identifierRegistry.getIdentifier(context);
        IVertex contextVertex = this.graph.addVertexIfAbsent(contextId);
        contextVertex.setPropertyIfAbsent("type", (Object)VertexType.DEPLOYMENT_CONTEXT);
        contextVertex.setPropertyIfAbsent("name", context.getName());
        IGraph contextSubgraph = contextVertex.addChildGraphIfAbsent();
        contextSubgraph.setName(context.getName());
        int componentId = this.identifierRegistry.getIdentifier(component);
        IVertex componentVertex = contextSubgraph.addVertexIfAbsent(componentId);
        componentVertex.setPropertyIfAbsent("type", (Object)VertexType.DEPLOYED_COMPONENT);
        componentVertex.setPropertyIfAbsent("name", component.getAssemblyComponent().getComponentType().getName());
        componentVertex.setPropertyIfAbsent("package name", component.getAssemblyComponent().getComponentType().getPackage());
        IGraph componentSubgraph = componentVertex.addChildGraphIfAbsent();
        componentSubgraph.setName(component.getAssemblyComponent().getComponentType().getName());
        int operationId = this.identifierRegistry.getIdentifier(operation);
        IVertex operationVertex = componentSubgraph.addVertexIfAbsent(operationId);
        operationVertex.setPropertyIfAbsent("type", (Object)VertexType.DEPLOYED_OPERATION);
        operationVertex.setPropertyIfAbsent("name", operation.getAssemblyOperation().getOperationType().getName());
        operationVertex.setPropertyIfAbsent("return type", operation.getAssemblyOperation().getOperationType().getReturnType());
        operationVertex.setPropertyIfAbsent("modifiers", operation.getAssemblyOperation().getOperationType().getModifiers());
        operationVertex.setPropertyIfAbsent("parameter types", operation.getAssemblyOperation().getOperationType().getParameterTypes());
        this.responseTimeDecorator.decorate(operationVertex, operation);
        return operationVertex;
    }
}

