/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.graph.export.dot;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Function;
import kieker.analysis.graph.IGraph;
import kieker.analysis.graph.export.dot.DotExportConfiguration;
import kieker.analysis.graph.export.dot.DotWriterStage;
import kieker.analysis.graph.export.dot.SimpleDotExportConfiguration;
import kieker.analysis.graph.mapping.SimpleFileNameMapper;
import kieker.analysis.graph.util.FileExtension;

public class DotFileWriterStage
extends DotWriterStage {
    public DotFileWriterStage(Function<IGraph, Path> fileNameMapper) {
        this(fileNameMapper, (DotExportConfiguration)new SimpleDotExportConfiguration());
    }

    public DotFileWriterStage(Function<IGraph, Path> fileNameMapper, DotExportConfiguration exportConfiguration) {
        super(fileNameMapper.andThen(fileName -> {
            try {
                return Files.newBufferedWriter(fileName, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }), exportConfiguration);
    }

    public DotFileWriterStage(Path outputDirectory) {
        this(outputDirectory, (DotExportConfiguration)new SimpleDotExportConfiguration());
    }

    public DotFileWriterStage(Path outputDirectory, DotExportConfiguration exportConfiguration) {
        this(new SimpleFileNameMapper(outputDirectory, FileExtension.DOT), exportConfiguration);
    }
}

