/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.filesystem;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kieker.analysis.plugin.reader.filesystem.BinaryFileStreamProcessor;
import kieker.analysis.plugin.reader.filesystem.TextFileStreamProcessor;
import kieker.analysis.plugin.reader.util.IMonitoringRecordReceiver;
import kieker.analysis.tt.reader.filesystem.util.MappingException;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.exception.UnknownRecordTypeException;
import kieker.common.registry.reader.ReaderRegistry;
import kieker.common.util.filesystem.FSUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class FSZipReader
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FSZipReader.class);
    private final File zipFile;
    private final IMonitoringRecordReceiver recordReceiver;
    private final boolean ignoreUnknownRecordTypes;
    private final ReaderRegistry<String> stringRegistry = new ReaderRegistry();
    private boolean terminated;
    private final BinaryFileStreamProcessor binaryFileStreamProcessor;
    private final TextFileStreamProcessor textFileStreamProcessor;

    public FSZipReader(File zipFile, IMonitoringRecordReceiver recordReceiver, boolean ignoreUnknownRecordTypes) {
        if (zipFile == null || !zipFile.isFile() || !zipFile.getName().endsWith(".zip")) {
            throw new IllegalArgumentException("Invalid zip file");
        }
        this.zipFile = zipFile;
        this.recordReceiver = recordReceiver;
        this.ignoreUnknownRecordTypes = ignoreUnknownRecordTypes;
        this.binaryFileStreamProcessor = new BinaryFileStreamProcessor(this.stringRegistry, recordReceiver);
        this.textFileStreamProcessor = new TextFileStreamProcessor(ignoreUnknownRecordTypes, this.stringRegistry, recordReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(Files.newInputStream(this.zipFile.toPath(), StandardOpenOption.READ));
            while (null != (zipEntry = zipInputStream.getNextEntry()) && !zipEntry.getName().equals("kieker.map")) {
            }
            if (null == zipEntry) {
                LOGGER.error("The zip file does not contain a Kieker log: {}", (Object)this.zipFile.toString());
                this.recordReceiver.newEndOfFileRecord();
                return;
            }
            this.readMappingFile(zipInputStream);
        }
        catch (IOException ex) {
            LOGGER.error("Error accessing ZipInputStream", ex);
            this.recordReceiver.newEndOfFileRecord();
            return;
        }
        finally {
            if (null != zipInputStream) {
                try {
                    zipInputStream.close();
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to close ZipInputStream", ex);
                }
            }
        }
        BufferedReader reader = null;
        FilterInputStream input = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(Files.newInputStream(this.zipFile.toPath(), StandardOpenOption.READ));
            reader = new BufferedReader(new InputStreamReader((InputStream)zipInputStream, "UTF-8"));
            input = new DataInputStream(new BufferedInputStream(zipInputStream, 0x100000));
            while (null != (zipEntry = zipInputStream.getNextEntry())) {
                if (this.terminated) {
                    LOGGER.info("Shutting down DirectoryReader.");
                    break;
                }
                String filename = zipEntry.getName();
                if (!filename.startsWith("kieker")) continue;
                if (filename.endsWith(".dat")) {
                    LOGGER.info("< Loading {}", (Object)filename);
                    try {
                        this.textFileStreamProcessor.processInputChannel(input);
                    }
                    catch (MappingException | MonitoringRecordException | UnknownRecordTypeException e) {
                        LOGGER.error("Cannot deserialize text record {}", e);
                    }
                    continue;
                }
                if (!filename.endsWith(".bin")) continue;
                LOGGER.info("< Loading {}", (Object)filename);
                if (this.ignoreUnknownRecordTypes) {
                    LOGGER.warn("The property '{}' is not supported for binary files. But trying to read '{}'", (Object)"ignoreUnknownRecordTypes", (Object)filename);
                }
                try {
                    this.binaryFileStreamProcessor.createRecordsFromBinaryFile((DataInputStream)input);
                }
                catch (IOException | MonitoringRecordException e) {
                    LOGGER.error("Cannot deserialize binary record {}", e);
                }
                this.terminated = true;
            }
        }
        catch (IOException ex) {
            LOGGER.error("Error accessing ZipInputStream", ex);
            this.recordReceiver.newEndOfFileRecord();
            return;
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to close ZipInputStream", ex);
            }
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to close ZipInputStream", ex);
            }
            try {
                if (null != input) {
                    input.close();
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to close ZipInputStream", ex);
            }
        }
        this.recordReceiver.newEndOfFileRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readMappingFile(ZipInputStream zipInputStream) throws IOException {
        try (BufferedReader in = null;){
            String line;
            in = new BufferedReader(new InputStreamReader((InputStream)zipInputStream, "UTF-8"));
            while ((line = in.readLine()) != null) {
                Integer id;
                if (line.length() == 0) continue;
                int split = line.indexOf(61);
                if (split == -1) {
                    LOGGER.error("Failed to parse line: {} from mapping file in zip file {}. Each line must contain ID=VALUE pairs.", (Object)line, (Object)this.zipFile.toString());
                    continue;
                }
                String key = line.substring(0, split);
                String value = FSUtil.decodeNewline(line.substring(split + 1));
                try {
                    id = Integer.valueOf(key.charAt(0) == '$' ? key.substring(1) : key);
                }
                catch (NumberFormatException ex) {
                    LOGGER.error("Error reading mapping file, id must be integer", ex);
                    continue;
                }
                String prevVal = this.stringRegistry.register(id.intValue(), value);
                if (prevVal == null) continue;
                LOGGER.error("Found addional entry for id='{}', old value was '{}' new value is '{}'", id, prevVal, value);
            }
        }
    }
}

