/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.newio;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.List;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.analysis.plugin.reader.newio.deserializer.IMonitoringRecordDeserializer;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRawDataReader
extends AbstractReaderPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRawDataReader.class.getCanonicalName());
    private final IMonitoringRecordDeserializer deserializer;

    public AbstractRawDataReader(Configuration configuration, IProjectContext projectContext, String deserializerClassName) {
        super(configuration, projectContext);
        this.deserializer = this.createDeserializer(deserializerClassName, configuration, projectContext);
    }

    private IMonitoringRecordDeserializer createDeserializer(String deserializerClassName, Configuration configuration, IProjectContext projectContext) {
        IMonitoringRecordDeserializer localDeserializer = null;
        try {
            Class<?> deserializerClass = Class.forName(deserializerClassName);
            Constructor<?> constructor = deserializerClass.getConstructor(Configuration.class, IProjectContext.class);
            localDeserializer = (IMonitoringRecordDeserializer)constructor.newInstance(configuration, projectContext);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("The deserializer class '{}' was not found.", (Object)deserializerClassName);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("The deserializer class '{}' does not provide a suitable constructor.", (Object)deserializerClassName);
        }
        catch (InstantiationException e) {
            this.logInstantiationFailed(deserializerClassName, e);
        }
        catch (IllegalAccessException e) {
            this.logInstantiationFailed(deserializerClassName, e);
        }
        catch (IllegalArgumentException e) {
            this.logInstantiationFailed(deserializerClassName, e);
        }
        catch (InvocationTargetException e) {
            this.logInstantiationFailed(deserializerClassName, e);
        }
        return localDeserializer;
    }

    private void logInstantiationFailed(String className, Throwable e) {
        LOGGER.error("The deserializer class '{}' could not be instantiated.", (Object)className, (Object)e);
    }

    protected void decodeAndDeliverRecords(byte[] rawData, String outputPortName) {
        this.decodeAndDeliverRecords(ByteBuffer.wrap(rawData), rawData.length, outputPortName);
    }

    protected void decodeAndDeliverRecords(ByteBuffer rawData, int dataSize, String outputPortName) {
        List<IMonitoringRecord> monitoringRecords = this.deserializer.deserializeRecords(rawData, dataSize);
        for (IMonitoringRecord monitoringRecord : monitoringRecords) {
            this.deliver(outputPortName, monitoringRecord);
        }
    }
}

