/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.stage.model;

import java.util.function.Function;
import kieker.analysis.stage.model.data.OperationCallDurationEvent;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.execution.ExecutionFactory;
import kieker.model.analysismodel.execution.ExecutionModel;
import kieker.model.analysismodel.execution.Tuple;
import kieker.model.analysismodel.trace.OperationCall;
import org.eclipse.emf.ecore.EObject;

public final class ModelObjectFromOperationCallAccessorUtils {
    public static final Function<OperationCallDurationEvent, EObject> DEPLOYED_OPERATION = c -> c.getOperationCall().getSecond();
    public static final Function<OperationCall, EObject> DEPLOYED_COMPONENT = c -> c.getOperation().getComponent();
    public static final Function<OperationCall, EObject> DEPLOYMENT_CONTEXT = c -> c.getOperation().getComponent().getDeploymentContext();
    public static final Function<OperationCall, EObject> ASSEMBLY_OPERATION = c -> c.getOperation().getAssemblyOperation();
    public static final Function<OperationCall, EObject> ASSEMBLY_COMPONENT = c -> c.getOperation().getAssemblyOperation().getAssemblyComponent();
    public static final Function<OperationCall, EObject> OPERATION_TYPE = c -> c.getOperation().getAssemblyOperation().getOperationType();
    public static final Function<OperationCall, EObject> COMPONENT_TYPE = c -> c.getOperation().getAssemblyOperation().getOperationType().getComponentType();

    private ModelObjectFromOperationCallAccessorUtils() {
    }

    public static final Function<OperationCall, EObject> findAggregatedInvocation4OperationCall(ExecutionModel executionModel) {
        return operationCall -> {
            DeployedOperation source = operationCall.getParent() != null ? operationCall.getParent().getOperation() : null;
            DeployedOperation target = operationCall.getOperation();
            Tuple<DeployedOperation, DeployedOperation> key = ExecutionFactory.eINSTANCE.createTuple();
            key.setFirst(source);
            key.setSecond(target);
            return (EObject)executionModel.getAggregatedInvocations().get(key);
        };
    }

    public static final Function<OperationCallDurationEvent, EObject> findAggregatedInvocation4OperationTuple(ExecutionModel executionModel) {
        return operationCall -> (EObject)executionModel.getAggregatedInvocations().get(operationCall.getOperationCall());
    }
}

