/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.trace.aggregation;

import com.google.common.base.Equivalence;
import java.util.HashMap;
import java.util.Map;
import kieker.analysis.trace.aggregation.AggregatedTraceWrapper;
import kieker.analysis.trace.aggregation.TraceEquivalence;
import kieker.model.analysismodel.trace.OperationCall;
import kieker.model.analysismodel.trace.Trace;
import kieker.model.analysismodel.trace.TraceFactory;

public class TraceAggregator {
    private final TraceFactory traceFactory = TraceFactory.eINSTANCE;
    private final boolean considerFailed;
    private final TraceEquivalence traceEquivalence;
    private final Map<Equivalence.Wrapper<Trace>, Trace> aggregatedTraces = new HashMap<Equivalence.Wrapper<Trace>, Trace>();

    public TraceAggregator(boolean considerFailed) {
        this.considerFailed = considerFailed;
        this.traceEquivalence = new TraceEquivalence(considerFailed);
    }

    public AggregatedTraceWrapper handleTrace(Trace trace) {
        Equivalence.Wrapper equalityWrappedTrace = this.traceEquivalence.wrap(trace);
        Trace aggregatedTrace = this.aggregatedTraces.get(equalityWrappedTrace);
        boolean isFirst = false;
        if (aggregatedTrace == null) {
            aggregatedTrace = this.createAggregatedTrace(trace);
            this.aggregatedTraces.put((Equivalence.Wrapper<Trace>)equalityWrappedTrace, aggregatedTrace);
            isFirst = true;
        }
        return new AggregatedTraceWrapper(aggregatedTrace, trace, isFirst);
    }

    private Trace createAggregatedTrace(Trace trace) {
        OperationCall aggregatedRootOperationCall = this.createAggregatedOperationCall(trace.getRootOperationCall());
        Trace aggregatedTrace = this.traceFactory.createTrace();
        aggregatedTrace.setRootOperationCall(aggregatedRootOperationCall);
        return aggregatedTrace;
    }

    private OperationCall createAggregatedOperationCall(OperationCall call) {
        OperationCall aggregatedCall = this.traceFactory.createOperationCall();
        if (this.considerFailed) {
            aggregatedCall.setFailed(call.isFailed());
            aggregatedCall.setFailedCause(call.getFailedCause());
        }
        call.getChildren().forEach(c -> aggregatedCall.getChildren().add((Object)this.createAggregatedOperationCall((OperationCall)c)));
        return aggregatedCall;
    }
}

