/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.trace.reconstruction;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.Deque;
import java.util.LinkedList;
import kieker.analysis.util.time.Instants;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.model.analysismodel.deployment.DeployedComponent;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.deployment.DeploymentContext;
import kieker.model.analysismodel.deployment.DeploymentModel;
import kieker.model.analysismodel.trace.OperationCall;
import kieker.model.analysismodel.trace.Trace;
import kieker.model.analysismodel.trace.TraceFactory;

public class TraceReconstructionBuffer {
    private final TraceFactory factory = TraceFactory.eINSTANCE;
    private final DeploymentModel deploymentModel;
    private final TraceMetadata traceMetadata;
    private final TemporalUnit temporalUnit;
    private final Deque<BeforeOperationEvent> stack = new LinkedList<BeforeOperationEvent>();
    private OperationCall root;
    private OperationCall current;

    public TraceReconstructionBuffer(DeploymentModel deploymentModel, TraceMetadata traceMetadata, TemporalUnit temporalUnit) {
        this.deploymentModel = deploymentModel;
        this.traceMetadata = traceMetadata;
        this.temporalUnit = temporalUnit;
    }

    public void handleBeforeOperationEventRecord(BeforeOperationEvent record) {
        this.stack.push(record);
        OperationCall newCall = this.factory.createOperationCall();
        Instant start = Instants.createFromEpochTimestamp(record.getTimestamp(), this.temporalUnit);
        newCall.setStart(start);
        DeploymentContext context = (DeploymentContext)this.deploymentModel.getDeploymentContexts().get((Object)this.traceMetadata.getHostname());
        DeployedComponent component = (DeployedComponent)context.getComponents().get((Object)record.getClassSignature());
        DeployedOperation operation = (DeployedOperation)component.getContainedOperations().get((Object)record.getOperationSignature());
        newCall.setOperation(operation);
        newCall.setOrderIndex(record.getOrderIndex());
        newCall.setStackDepth(this.stack.size() - 1);
        if (this.root == null) {
            this.root = newCall;
        } else {
            this.current.getChildren().add((Object)newCall);
        }
        this.current = newCall;
    }

    public void handleAfterOperationEventRecord(AfterOperationEvent record) {
        BeforeOperationEvent beforeEvent = this.stack.pop();
        long timestampDifference = record.getTimestamp() - beforeEvent.getTimestamp();
        this.current.setDuration(Duration.of(timestampDifference, this.temporalUnit));
        if (record instanceof AfterOperationFailedEvent) {
            String failedCause = ((AfterOperationFailedEvent)record).getCause();
            this.current.setFailed(true);
            this.current.setFailedCause(failedCause);
        }
        this.current = this.current.getParent();
    }

    public Trace reconstructTrace() {
        Trace trace = this.factory.createTrace();
        trace.setRootOperationCall(this.root);
        trace.setTraceID(this.traceMetadata.getTraceId());
        return trace;
    }

    public boolean isTraceComplete() {
        return this.stack.isEmpty();
    }
}

