/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.tt.reader;

import java.nio.ByteBuffer;
import kieker.analysis.tt.reader.IRecordReceivedListener;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.io.BinaryValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordDeserializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordDeserializer.class);
    private final IRecordReceivedListener listener;
    private final ReaderRegistry<String> registry;
    private final CachedRecordFactoryCatalog recordFactories;

    public RecordDeserializer(IRecordReceivedListener listener, ReaderRegistry<String> registry) {
        this.listener = listener;
        this.registry = registry;
        this.recordFactories = CachedRecordFactoryCatalog.getInstance();
    }

    public boolean deserializeRecord(int clazzId, ByteBuffer buffer) {
        if (buffer.remaining() < 8) {
            return false;
        }
        String recordClassName = this.registry.get(clazzId);
        IRecordFactory<? extends IMonitoringRecord> recordFactory = this.recordFactories.get(recordClassName);
        if (recordFactory == null) {
            return false;
        }
        if (buffer.remaining() < recordFactory.getRecordSizeInBytes()) {
            return false;
        }
        long loggingTimestamp = buffer.getLong();
        BinaryValueDeserializer deserializer = BinaryValueDeserializer.create(buffer, this.registry);
        try {
            IMonitoringRecord record = recordFactory.create(deserializer);
            record.setLoggingTimestamp(loggingTimestamp);
            this.listener.onRecordReceived(record);
        }
        catch (RecordInstantiationException ex) {
            LOGGER.error("Failed to create: {}", (Object)recordClassName, (Object)ex);
        }
        return true;
    }
}

