/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.thread;

import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.AbstractEvent;
import kieker.common.record.flow.IClassSignature;
import kieker.common.record.flow.IOperationSignature;
import kieker.common.record.flow.IThreadBasedRecord;
import kieker.common.record.io.IValueDeserializer;

public abstract class AbstractThreadBasedEvent
extends AbstractEvent
implements IThreadBasedRecord,
IOperationSignature,
IClassSignature {
    public static final long THREAD_ID = -1L;
    public static final int ORDER_INDEX = -1;
    public static final String OPERATION_SIGNATURE = "";
    public static final String CLASS_SIGNATURE = "";
    private static final long serialVersionUID = -4756765331556509113L;
    private final long threadId;
    private final int orderIndex;
    private final String operationSignature;
    private final String classSignature;

    public AbstractThreadBasedEvent(long timestamp, long threadId, int orderIndex, String operationSignature, String classSignature) {
        super(timestamp);
        this.threadId = threadId;
        this.orderIndex = orderIndex;
        this.operationSignature = operationSignature == null ? "" : operationSignature;
        this.classSignature = classSignature == null ? "" : classSignature;
    }

    public AbstractThreadBasedEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.threadId = deserializer.getLong();
        this.orderIndex = deserializer.getInt();
        this.operationSignature = deserializer.getString();
        this.classSignature = deserializer.getString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractThreadBasedEvent castedRecord = (AbstractThreadBasedEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (this.getThreadId() != castedRecord.getThreadId()) {
            return false;
        }
        if (this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        if (!this.getOperationSignature().equals(castedRecord.getOperationSignature())) {
            return false;
        }
        return this.getClassSignature().equals(castedRecord.getClassSignature());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getThreadId();
        code += this.getOrderIndex();
        code += this.getOperationSignature().hashCode();
        return code += this.getClassSignature().hashCode();
    }

    @Override
    public final long getThreadId() {
        return this.threadId;
    }

    @Override
    public final int getOrderIndex() {
        return this.orderIndex;
    }

    @Override
    public final String getOperationSignature() {
        return this.operationSignature;
    }

    @Override
    public final String getClassSignature() {
        return this.classSignature;
    }

    @Override
    public String toString() {
        String result = "AbstractThreadBasedEvent: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "threadId = ";
        result = result + this.getThreadId() + ", ";
        result = result + "orderIndex = ";
        result = result + this.getOrderIndex() + ", ";
        result = result + "operationSignature = ";
        result = result + this.getOperationSignature() + ", ";
        result = result + "classSignature = ";
        result = result + this.getClassSignature() + ", ";
        return result;
    }
}

