/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.thread;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.IExceptionRecord;
import kieker.common.record.flow.thread.AbstractThreadBasedEvent;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class AfterFailedThreadBasedEvent
extends AbstractThreadBasedEvent
implements IExceptionRecord {
    public static final int SIZE = 32;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class, String.class};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "threadId", "orderIndex", "operationSignature", "classSignature", "cause"};
    public static final String CAUSE = "";
    private static final long serialVersionUID = -561668403011752179L;
    private final String cause;

    public AfterFailedThreadBasedEvent(long timestamp, long threadId, int orderIndex, String operationSignature, String classSignature, String cause) {
        super(timestamp, threadId, orderIndex, operationSignature, classSignature);
        this.cause = cause == null ? CAUSE : cause;
    }

    public AfterFailedThreadBasedEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.cause = deserializer.getString();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putLong(this.getThreadId());
        serializer.putInt(this.getOrderIndex());
        serializer.putString(this.getOperationSignature());
        serializer.putString(this.getClassSignature());
        serializer.putString(this.getCause());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 32;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AfterFailedThreadBasedEvent castedRecord = (AfterFailedThreadBasedEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (this.getThreadId() != castedRecord.getThreadId()) {
            return false;
        }
        if (this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        if (!this.getOperationSignature().equals(castedRecord.getOperationSignature())) {
            return false;
        }
        if (!this.getClassSignature().equals(castedRecord.getClassSignature())) {
            return false;
        }
        return this.getCause().equals(castedRecord.getCause());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getThreadId();
        code += this.getOrderIndex();
        code += this.getOperationSignature().hashCode();
        code += this.getClassSignature().hashCode();
        return code += this.getCause().hashCode();
    }

    @Override
    public final String getCause() {
        return this.cause;
    }

    @Override
    public String toString() {
        String result = "AfterFailedThreadBasedEvent: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "threadId = ";
        result = result + this.getThreadId() + ", ";
        result = result + "orderIndex = ";
        result = result + this.getOrderIndex() + ", ";
        result = result + "operationSignature = ";
        result = result + this.getOperationSignature() + ", ";
        result = result + "classSignature = ";
        result = result + this.getClassSignature() + ", ";
        result = result + "cause = ";
        result = result + this.getCause() + ", ";
        return result;
    }
}

