/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class ConstructionEvent
extends AbstractTraceEvent {
    public static final int SIZE = 28;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, Integer.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "traceId", "orderIndex", "classSignature", "objectId"};
    public static final String CLASS_SIGNATURE = "";
    public static final int OBJECT_ID = 0;
    private static final long serialVersionUID = 5435515970872711524L;
    private final String classSignature;
    private final int objectId;

    public ConstructionEvent(long timestamp, long traceId, int orderIndex, String classSignature, int objectId) {
        super(timestamp, traceId, orderIndex);
        this.classSignature = classSignature == null ? CLASS_SIGNATURE : classSignature;
        this.objectId = objectId;
    }

    public ConstructionEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.classSignature = deserializer.getString();
        this.objectId = deserializer.getInt();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putLong(this.getTraceId());
        serializer.putInt(this.getOrderIndex());
        serializer.putString(this.getClassSignature());
        serializer.putInt(this.getObjectId());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 28;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ConstructionEvent castedRecord = (ConstructionEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (this.getTraceId() != castedRecord.getTraceId()) {
            return false;
        }
        if (this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        if (!this.getClassSignature().equals(castedRecord.getClassSignature())) {
            return false;
        }
        return this.getObjectId() == castedRecord.getObjectId();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        code += this.getClassSignature().hashCode();
        return code += this.getObjectId();
    }

    public final String getClassSignature() {
        return this.classSignature;
    }

    public final int getObjectId() {
        return this.objectId;
    }

    @Override
    public String toString() {
        String result = "ConstructionEvent: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "traceId = ";
        result = result + this.getTraceId() + ", ";
        result = result + "orderIndex = ";
        result = result + this.getOrderIndex() + ", ";
        result = result + "classSignature = ";
        result = result + this.getClassSignature() + ", ";
        result = result + "objectId = ";
        result = result + this.getObjectId() + ", ";
        return result;
    }
}

