/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.system;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class CPUUtilizationRecord
extends AbstractMonitoringRecord {
    public static final int SIZE = 72;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "hostname", "cpuID", "user", "system", "wait", "nice", "irq", "totalUtilization", "idle"};
    public static final long TIMESTAMP = 0L;
    public static final String HOSTNAME = "";
    public static final String CPU_ID = "";
    public static final double USER = 0.0;
    public static final double SYSTEM = 0.0;
    public static final double WAIT = 0.0;
    public static final double NICE = 0.0;
    public static final double IRQ = 0.0;
    public static final double TOTAL_UTILIZATION = 0.0;
    public static final double IDLE = 0.0;
    private static final long serialVersionUID = -7851990890838902217L;
    private final long timestamp;
    private final String hostname;
    private final String cpuID;
    private final double user;
    private final double system;
    private final double wait;
    private final double nice;
    private final double irq;
    private final double totalUtilization;
    private final double idle;

    public CPUUtilizationRecord(long timestamp, String hostname, String cpuID, double user, double system, double wait, double nice, double irq, double totalUtilization, double idle) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? "" : hostname;
        this.cpuID = cpuID == null ? "" : cpuID;
        this.user = user;
        this.system = system;
        this.wait = wait;
        this.nice = nice;
        this.irq = irq;
        this.totalUtilization = totalUtilization;
        this.idle = idle;
    }

    public CPUUtilizationRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.timestamp = deserializer.getLong();
        this.hostname = deserializer.getString();
        this.cpuID = deserializer.getString();
        this.user = deserializer.getDouble();
        this.system = deserializer.getDouble();
        this.wait = deserializer.getDouble();
        this.nice = deserializer.getDouble();
        this.irq = deserializer.getDouble();
        this.totalUtilization = deserializer.getDouble();
        this.idle = deserializer.getDouble();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getHostname());
        serializer.putString(this.getCpuID());
        serializer.putDouble(this.getUser());
        serializer.putDouble(this.getSystem());
        serializer.putDouble(this.getWait());
        serializer.putDouble(this.getNice());
        serializer.putDouble(this.getIrq());
        serializer.putDouble(this.getTotalUtilization());
        serializer.putDouble(this.getIdle());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 72;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CPUUtilizationRecord castedRecord = (CPUUtilizationRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (!this.getHostname().equals(castedRecord.getHostname())) {
            return false;
        }
        if (!this.getCpuID().equals(castedRecord.getCpuID())) {
            return false;
        }
        if (CPUUtilizationRecord.isNotEqual(this.getUser(), castedRecord.getUser())) {
            return false;
        }
        if (CPUUtilizationRecord.isNotEqual(this.getSystem(), castedRecord.getSystem())) {
            return false;
        }
        if (CPUUtilizationRecord.isNotEqual(this.getWait(), castedRecord.getWait())) {
            return false;
        }
        if (CPUUtilizationRecord.isNotEqual(this.getNice(), castedRecord.getNice())) {
            return false;
        }
        if (CPUUtilizationRecord.isNotEqual(this.getIrq(), castedRecord.getIrq())) {
            return false;
        }
        if (CPUUtilizationRecord.isNotEqual(this.getTotalUtilization(), castedRecord.getTotalUtilization())) {
            return false;
        }
        return !CPUUtilizationRecord.isNotEqual(this.getIdle(), castedRecord.getIdle());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getHostname().hashCode();
        code += this.getCpuID().hashCode();
        code += (int)this.getUser();
        code += (int)this.getSystem();
        code += (int)this.getWait();
        code += (int)this.getNice();
        code += (int)this.getIrq();
        code += (int)this.getTotalUtilization();
        return code += (int)this.getIdle();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final String getCpuID() {
        return this.cpuID;
    }

    public final double getUser() {
        return this.user;
    }

    public final double getSystem() {
        return this.system;
    }

    public final double getWait() {
        return this.wait;
    }

    public final double getNice() {
        return this.nice;
    }

    public final double getIrq() {
        return this.irq;
    }

    public final double getTotalUtilization() {
        return this.totalUtilization;
    }

    public final double getIdle() {
        return this.idle;
    }

    @Override
    public String toString() {
        String result = "CPUUtilizationRecord: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "hostname = ";
        result = result + this.getHostname() + ", ";
        result = result + "cpuID = ";
        result = result + this.getCpuID() + ", ";
        result = result + "user = ";
        result = result + this.getUser() + ", ";
        result = result + "system = ";
        result = result + this.getSystem() + ", ";
        result = result + "wait = ";
        result = result + this.getWait() + ", ";
        result = result + "nice = ";
        result = result + this.getNice() + ", ";
        result = result + "irq = ";
        result = result + this.getIrq() + ", ";
        result = result + "totalUtilization = ";
        result = result + this.getTotalUtilization() + ", ";
        result = result + "idle = ";
        result = result + this.getIdle() + ", ";
        return result;
    }
}

