/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.util.classpath;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.common.util.classpath.ClassForNameResolver;

public class CachedClassForNameResolver<T> {
    private final ConcurrentMap<String, Class<? extends T>> cachedClasses = new ConcurrentHashMap<String, Class<? extends T>>();
    private final ClassForNameResolver<T> classForNameResolver;

    public CachedClassForNameResolver(ClassForNameResolver<T> classForNameResolver) {
        this.classForNameResolver = classForNameResolver;
    }

    public final Class<? extends T> classForName(String classname) throws ClassNotFoundException {
        Class<T> previousClass;
        Class<T> clazz = (Class<T>)this.cachedClasses.get(classname);
        if (clazz == null && null != (previousClass = this.cachedClasses.putIfAbsent(classname, clazz = this.classForNameResolver.classForName(classname)))) {
            clazz = previousClass;
        }
        return clazz;
    }
}

