/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller.tcp;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.IRecordReceivedListener;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.io.BinaryValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;
import kieker.monitoring.core.controller.tcp.AbstractTcpReader;
import org.slf4j.Logger;

public class SingleSocketRecordReader
extends AbstractTcpReader {
    private static final Charset ENCODING = Charset.forName("UTF-8");
    private final ReaderRegistry<String> readerRegistry = new ReaderRegistry();
    private final IRecordReceivedListener listener;
    private final CachedRecordFactoryCatalog recordFactories = new CachedRecordFactoryCatalog();

    public SingleSocketRecordReader(int port, int bufferCapacity, Logger logger, IRecordReceivedListener listener) {
        super(port, bufferCapacity, logger);
        this.listener = listener;
    }

    public SingleSocketRecordReader(int port, int bufferCapacity, Logger logger, boolean respawn, IRecordReceivedListener listener) {
        super(port, bufferCapacity, logger, respawn);
        this.listener = listener;
    }

    @Override
    protected boolean onBufferReceived(ByteBuffer buffer) {
        if (buffer.remaining() >= 4) {
            int clazzId = buffer.getInt();
            if (clazzId == -1) {
                return this.registerEntry(buffer);
            }
            return this.deserializeRecord(clazzId, buffer);
        }
        return false;
    }

    private boolean registerEntry(ByteBuffer buffer) {
        if (buffer.remaining() >= 8) {
            int id = buffer.getInt();
            int stringLength = buffer.getInt();
            if (buffer.remaining() < stringLength) {
                return false;
            }
            byte[] strBytes = new byte[stringLength];
            buffer.get(strBytes);
            String string = new String(strBytes, ENCODING);
            this.readerRegistry.register(id, string);
            return true;
        }
        return false;
    }

    private boolean deserializeRecord(int clazzId, ByteBuffer buffer) {
        if (buffer.remaining() >= 8) {
            long loggingTimestamp = buffer.getLong();
            String recordClassName = this.readerRegistry.get(clazzId);
            if (recordClassName != null) {
                IRecordFactory<? extends IMonitoringRecord> recordFactory = this.recordFactories.get(recordClassName);
                if (buffer.remaining() >= recordFactory.getRecordSizeInBytes()) {
                    try {
                        IMonitoringRecord record = recordFactory.create(BinaryValueDeserializer.create(buffer, this.readerRegistry));
                        record.setLoggingTimestamp(loggingTimestamp);
                        this.listener.onRecordReceived(record);
                        return true;
                    }
                    catch (BufferUnderflowException ex) {
                        this.logger.warn("Cannot create {}; missing data in byte buffer. Buffer remaining {}", (Object)recordClassName, (Object)buffer.remaining());
                        return false;
                    }
                    catch (RecordInstantiationException ex) {
                        this.logger.error("Failed to create {}", (Object)recordClassName, (Object)ex);
                        return false;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

