/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.oshi.samplers;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kieker.common.record.system.NetworkUtilizationRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.signaturePattern.SignatureFactory;
import kieker.monitoring.sampler.oshi.samplers.AbstractOshiSampler;
import kieker.monitoring.timer.ITimeSource;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;

public final class NetworkUtilizationSampler
extends AbstractOshiSampler {
    private final ConcurrentHashMap<String, NetworkStatistic> networkStatisticMap = new ConcurrentHashMap();

    public NetworkUtilizationSampler(HardwareAbstractionLayer hardwareAbstractionLayer) {
        super(hardwareAbstractionLayer);
    }

    @Override
    public void sample(IMonitoringController monitoringController) {
        NetworkIF[] networkInterfaces;
        if (!monitoringController.isMonitoringEnabled() || !monitoringController.isProbeActivated(SignatureFactory.createNetworkUtilizationSignature())) {
            return;
        }
        for (NetworkIF networkIF : networkInterfaces = this.hardwareAbstractionLayer.getNetworkIFs()) {
            String interfaceName = networkIF.getName();
            ITimeSource timesource = monitoringController.getTimeSource();
            TimeUnit timeUnit = timesource.getTimeUnit();
            NetworkStatistic currentNetworkStatistic = this.getCurrentNetworkStatistic(timesource, networkIF);
            if (!this.networkStatisticMap.containsKey(interfaceName)) {
                this.networkStatisticMap.putIfAbsent(interfaceName, currentNetworkStatistic);
                continue;
            }
            NetworkStatistic lastObservedNetworkStatistic = this.networkStatisticMap.get(interfaceName);
            long timeDifference = currentNetworkStatistic.getTimestamp() - lastObservedNetworkStatistic.getTimestamp();
            if (timeDifference <= 0L) {
                throw new IllegalStateException("Timestamp of new observation should be strictly larger than the previous one.");
            }
            long txBytesDifference = currentNetworkStatistic.getTxBytes() - lastObservedNetworkStatistic.getTxBytes();
            long txCarrierDifference = currentNetworkStatistic.getTxCarrier() - lastObservedNetworkStatistic.getTxCarrier();
            long txCollisionsDifference = currentNetworkStatistic.getTxCollisions() - lastObservedNetworkStatistic.getTxCollisions();
            long txDroppedDifference = currentNetworkStatistic.getTxDropped() - lastObservedNetworkStatistic.getTxDropped();
            long txErrorsDifference = currentNetworkStatistic.getTxErrors() - lastObservedNetworkStatistic.getTxErrors();
            long txOverrunsDifference = currentNetworkStatistic.getTxOverruns() - lastObservedNetworkStatistic.getTxOverruns();
            long txPacketsDifference = currentNetworkStatistic.getTxPackets() - lastObservedNetworkStatistic.getTxPackets();
            long rxBytesDifference = currentNetworkStatistic.getRxBytes() - lastObservedNetworkStatistic.getRxBytes();
            long rxDroppedDifference = currentNetworkStatistic.getRxDropped() - lastObservedNetworkStatistic.getRxDropped();
            long rxErrorsDifference = currentNetworkStatistic.getRxErrors() - lastObservedNetworkStatistic.getRxErrors();
            long rxFrameDifference = currentNetworkStatistic.getRxFrame() - lastObservedNetworkStatistic.getRxFrame();
            long rxOverrunsDifference = currentNetworkStatistic.getRxOverruns() - lastObservedNetworkStatistic.getRxOverruns();
            long rxPacketsDifference = currentNetworkStatistic.getRxPackets() - lastObservedNetworkStatistic.getRxPackets();
            double txBytesPerSecond = (double)txBytesDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double txCarrierPerSecond = (double)txCarrierDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double txCollisionsPerSecond = (double)txCollisionsDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double txDroppedPerSecond = (double)txDroppedDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double txErrorsPerSecond = (double)txErrorsDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double txOverrunsPerSecond = (double)txOverrunsDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double txPacketsPerSecond = (double)txPacketsDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double rxBytesPerSecond = (double)rxBytesDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double rxDroppedPerSecond = (double)rxDroppedDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double rxErrorsPerSecond = (double)rxErrorsDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double rxFramePerSecond = (double)rxFrameDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double rxOverrunsPerSecond = (double)rxOverrunsDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double rxPacketsPerSecond = (double)rxPacketsDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            NetworkUtilizationRecord r = new NetworkUtilizationRecord(currentNetworkStatistic.getTimestamp(), monitoringController.getHostname(), interfaceName, currentNetworkStatistic.getSpeed(), txBytesPerSecond, txCarrierPerSecond, txCollisionsPerSecond, txDroppedPerSecond, txErrorsPerSecond, txOverrunsPerSecond, txPacketsPerSecond, rxBytesPerSecond, rxDroppedPerSecond, rxErrorsPerSecond, rxFramePerSecond, rxOverrunsPerSecond, rxPacketsPerSecond);
            monitoringController.newMonitoringRecord(r);
            this.networkStatisticMap.put(interfaceName, currentNetworkStatistic);
        }
    }

    private NetworkStatistic getCurrentNetworkStatistic(ITimeSource timesource, NetworkIF networkIF) {
        long currentTimestamp = timesource.getTime();
        long speed = networkIF.getSpeed();
        long txBytes = networkIF.getBytesSent();
        long txCarrier = 0L;
        long txCollisions = 0L;
        long txDropped = 0L;
        long txErrors = networkIF.getOutErrors();
        long txOverruns = 0L;
        long txPackets = networkIF.getPacketsSent();
        long rxBytes = networkIF.getBytesRecv();
        long rxDropped = 0L;
        long rxErrors = networkIF.getInErrors();
        long rxFrame = 0L;
        long rxOverruns = 0L;
        long rxPackets = networkIF.getPacketsRecv();
        return new NetworkStatistic(currentTimestamp, speed, txBytes, 0L, 0L, 0L, txErrors, 0L, txPackets, rxBytes, 0L, rxErrors, 0L, 0L, rxPackets);
    }

    static class NetworkStatistic {
        private final long timestamp;
        private final long speed;
        private final long txBytes;
        private final long txCarrier;
        private final long txCollisions;
        private final long txDropped;
        private final long txErrors;
        private final long txOverruns;
        private final long txPackets;
        private final long rxBytes;
        private final long rxDropped;
        private final long rxErrors;
        private final long rxFrame;
        private final long rxOverruns;
        private final long rxPackets;

        public NetworkStatistic(long timestamp, long speed, long txBytes, long txCarrier, long txCollisions, long txDropped, long txErrors, long txOverruns, long txPackets, long rxBytes, long rxDropped, long rxErrors, long rxFrame, long rxOverruns, long rxPackets) {
            this.timestamp = timestamp;
            this.speed = speed;
            this.txBytes = txBytes;
            this.txCarrier = txCarrier;
            this.txCollisions = txCollisions;
            this.txDropped = txDropped;
            this.txErrors = txErrors;
            this.txOverruns = txOverruns;
            this.txPackets = txPackets;
            this.rxBytes = rxBytes;
            this.rxDropped = rxDropped;
            this.rxErrors = rxErrors;
            this.rxFrame = rxFrame;
            this.rxOverruns = rxOverruns;
            this.rxPackets = rxPackets;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getSpeed() {
            return this.speed;
        }

        public long getTxBytes() {
            return this.txBytes;
        }

        public long getTxCarrier() {
            return this.txCarrier;
        }

        public long getTxCollisions() {
            return this.txCollisions;
        }

        public long getTxDropped() {
            return this.txDropped;
        }

        public long getTxErrors() {
            return this.txErrors;
        }

        public long getTxOverruns() {
            return this.txOverruns;
        }

        public long getTxPackets() {
            return this.txPackets;
        }

        public long getRxBytes() {
            return this.rxBytes;
        }

        public long getRxDropped() {
            return this.rxDropped;
        }

        public long getRxErrors() {
            return this.rxErrors;
        }

        public long getRxFrame() {
            return this.rxFrame;
        }

        public long getRxOverruns() {
            return this.rxOverruns;
        }

        public long getRxPackets() {
            return this.rxPackets;
        }
    }
}

