/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.namedRecordPipe;

import kieker.common.configuration.Configuration;
import kieker.common.namedRecordPipe.Broker;
import kieker.common.namedRecordPipe.Pipe;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.writer.AbstractMonitoringWriter;

public final class PipeWriter
extends AbstractMonitoringWriter {
    private static final String PREFIX = PipeWriter.class.getName() + ".";
    public static final String CONFIG_PIPENAME = PREFIX + "pipeName";
    private final Pipe pipe;

    public PipeWriter(Configuration configuration) {
        super(configuration);
        String pipeName = configuration.getStringProperty(CONFIG_PIPENAME);
        if (pipeName.length() == 0) {
            throw new IllegalArgumentException("Invalid or missing value for property '" + CONFIG_PIPENAME + "': '" + pipeName + "'");
        }
        this.pipe = Broker.INSTANCE.acquirePipe(pipeName);
    }

    public PipeWriter(String pipeName) {
        super(new Configuration());
        this.pipe = Broker.INSTANCE.acquirePipe(pipeName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(super.toString()).append("\n\tConnected to pipe: '").append(this.pipe.getName()).append('\'');
        return sb.toString();
    }

    @Override
    public void onStarting() {
    }

    @Override
    public void writeMonitoringRecord(IMonitoringRecord record) {
        this.pipe.writeMonitoringRecord(record);
    }

    @Override
    public void onTerminating() {
        this.pipe.close();
    }
}

