/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.io.BinaryValueSerializer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.registry.IRegistryListener;
import kieker.common.registry.writer.WriterRegistry;
import kieker.monitoring.writer.AbstractMonitoringWriter;
import kieker.monitoring.writer.WriterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualSocketTcpWriter
extends AbstractMonitoringWriter
implements IRegistryListener<String> {
    private static final int DEFAULT_STRING_REGISTRY_BUFFER_SIZE = 1024;
    private static final Logger LOGGER = LoggerFactory.getLogger(DualSocketTcpWriter.class);
    private static final String PREFIX = DualSocketTcpWriter.class.getName() + ".";
    public static final String CONFIG_HOSTNAME = PREFIX + "hostname";
    public static final String CONFIG_PORT1 = PREFIX + "port1";
    public static final String CONFIG_PORT2 = PREFIX + "port2";
    public static final String CONFIG_BUFFERSIZE = PREFIX + "bufferSize";
    public static final String CONFIG_FLUSH = PREFIX + "flush";
    private static final String CONFIG_STRING_REGISTRY_BUFFERSIZE = PREFIX + "StringRegistryBufferSize";
    private final boolean flush;
    private final SocketChannel monitoringRecordChannel;
    private final SocketChannel registryRecordChannel;
    private final ByteBuffer recordBuffer;
    private final ByteBuffer stringRegistryBuffer;
    private final IValueSerializer serializer;

    public DualSocketTcpWriter(Configuration configuration) throws IOException {
        super(configuration);
        String hostname = configuration.getStringProperty(CONFIG_HOSTNAME);
        int monitoringPort = configuration.getIntProperty(CONFIG_PORT1);
        int registryPort = configuration.getIntProperty(CONFIG_PORT2);
        int bufferSize = configuration.getIntProperty(CONFIG_BUFFERSIZE);
        int stringRegistryBufferSize = configuration.getIntProperty(CONFIG_STRING_REGISTRY_BUFFERSIZE);
        if (stringRegistryBufferSize <= 0) {
            LOGGER.warn("Invalid buffer size passed for string registry records: {}. Defaults to {}", (Object)stringRegistryBufferSize, (Object)1024);
            stringRegistryBufferSize = 1024;
        }
        this.flush = configuration.getBooleanProperty(CONFIG_FLUSH);
        this.recordBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.stringRegistryBuffer = ByteBuffer.allocateDirect(stringRegistryBufferSize);
        this.monitoringRecordChannel = SocketChannel.open(new InetSocketAddress(hostname, monitoringPort));
        this.registryRecordChannel = SocketChannel.open(new InetSocketAddress(hostname, registryPort));
        WriterRegistry writerRegistry = new WriterRegistry(this);
        this.serializer = BinaryValueSerializer.create(this.recordBuffer, writerRegistry);
    }

    @Override
    public void onStarting() {
    }

    @Override
    public void writeMonitoringRecord(IMonitoringRecord monitoringRecord) {
        ByteBuffer buffer = this.recordBuffer;
        int requiredBufferSize = 12 + monitoringRecord.getSize();
        if (requiredBufferSize > buffer.remaining()) {
            WriterUtil.flushBuffer(buffer, this.monitoringRecordChannel, LOGGER);
        }
        String recordClassName = monitoringRecord.getClass().getName();
        this.serializer.putString(recordClassName);
        this.serializer.putLong(monitoringRecord.getLoggingTimestamp());
        monitoringRecord.serialize(this.serializer);
        if (this.flush) {
            WriterUtil.flushBuffer(buffer, this.monitoringRecordChannel, LOGGER);
        }
    }

    @Override
    public void onNewRegistryEntry(String value, int id) {
        ByteBuffer buffer = this.stringRegistryBuffer;
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        int requiredBufferSize = 8 + bytes.length;
        if (buffer.capacity() < requiredBufferSize) {
            throw new IllegalStateException("Insufficient capacity for string registry buffer");
        }
        buffer.putInt(id);
        buffer.putInt(value.length());
        buffer.put(bytes);
        WriterUtil.flushBuffer(buffer, this.registryRecordChannel, LOGGER);
    }

    @Override
    public void onTerminating() {
        WriterUtil.flushBuffer(this.stringRegistryBuffer, this.registryRecordChannel, LOGGER);
        WriterUtil.flushBuffer(this.recordBuffer, this.monitoringRecordChannel, LOGGER);
        WriterUtil.close(this.registryRecordChannel, LOGGER);
        WriterUtil.close(this.monitoringRecordChannel, LOGGER);
    }
}

