/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace.call.tree;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import kieker.analysis.trace.AbstractMessageTraceProcessingFilter;
import kieker.model.repository.AllocationComponentOperationPairFactory;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.AllocationComponent;
import kieker.model.system.model.MessageTrace;
import kieker.model.system.model.Operation;
import kieker.model.system.model.SynchronousCallMessage;
import kieker.model.system.model.util.AllocationComponentOperationPair;
import kieker.tools.trace.analysis.filter.traceReconstruction.TraceProcessingException;
import kieker.tools.trace.analysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.trace.analysis.filter.visualization.graph.NoOriginRetentionPolicy;
import kieker.visualization.trace.call.tree.AbstractCallTreeFilter;
import kieker.visualization.trace.call.tree.TraceCallTreeNode;

public class TraceCallTreeFilter
extends AbstractMessageTraceProcessingFilter {
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_FILENAME = "dotOutputFn";
    public static final String CONFIG_PROPERTY_NAME_SHORT_LABELS = "shortLabels";
    public static final String CONFIG_PROPERTY_VALUE_OUTPUT_FILENAME_DEFAULT = "traceCalltree.dot";
    public static final String CONFIG_PROPERTY_VALUE_SHORT_LABELS_DEFAULT = "true";
    private final String dotOutputFn;
    private final boolean shortLabels;

    public TraceCallTreeFilter(SystemModelRepository repository, boolean shortLabels, String dotOutputFn) {
        super(repository);
        this.shortLabels = shortLabels;
        this.dotOutputFn = dotOutputFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStatusMessage() {
        TraceCallTreeFilter traceCallTreeFilter = this;
        synchronized (traceCallTreeFilter) {
            super.printStatusMessage();
            int numPlots = this.getSuccessCount();
            long lastSuccessTracesId = this.getLastTraceIdSuccess();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Wrote " + numPlots + " call tree" + (numPlots > 1 ? "s" : "") + " to file" + (numPlots > 1 ? "s" : "") + " with name pattern '" + this.dotOutputFn + "-<traceId>.dot'");
                this.logger.debug("Dot files can be converted using the dot tool");
                this.logger.debug("Example: dot -T svg " + this.dotOutputFn + "-" + (numPlots > 0 ? Long.valueOf(lastSuccessTracesId) : "<traceId>") + ".dot > " + this.dotOutputFn + "-" + (numPlots > 0 ? Long.valueOf(lastSuccessTracesId) : "<traceId>") + ".svg");
            }
        }
    }

    @Override
    protected void execute(MessageTrace mt) throws Exception {
        try {
            TraceCallTreeNode rootNode = new TraceCallTreeNode(0, AllocationComponentOperationPairFactory.ROOT_PAIR, true, mt, (IOriginRetentionPolicy)NoOriginRetentionPolicy.createInstance());
            AbstractCallTreeFilter.writeDotForMessageTrace(rootNode, new AbstractCallTreeFilter.IPairFactory<AllocationComponentOperationPair>(){

                @Override
                public AllocationComponentOperationPair createPair(SynchronousCallMessage callMsg) {
                    AllocationComponent allocationComponent = callMsg.getReceivingExecution().getAllocationComponent();
                    Operation op = callMsg.getReceivingExecution().getOperation();
                    AllocationComponentOperationPair destination = TraceCallTreeFilter.this.getSystemModelRepository().getAllocationPairFactory().getPairInstanceByPair(allocationComponent, op);
                    return destination;
                }
            }, mt, this.dotOutputFn + "-" + mt.getTraceId() + ".dot", false, this.shortLabels);
            this.reportSuccess(mt.getTraceId());
        }
        catch (TraceProcessingException ex) {
            this.reportError(mt.getTraceId());
            this.logger.error("TraceProcessingException", ex);
        }
        catch (FileNotFoundException ex) {
            this.reportError(mt.getTraceId());
            this.logger.error("File not found", ex);
        }
        catch (UnsupportedEncodingException ex) {
            this.reportError(mt.getTraceId());
            this.logger.error("Encoding not supported", ex);
        }
    }
}

