/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace.dependency.graph;

import kieker.common.util.signature.Signature;
import kieker.model.system.model.Operation;
import kieker.tools.trace.analysis.filter.visualization.AbstractGraphFormatter;
import kieker.visualization.trace.dependency.graph.AbstractDependencyGraph;
import kieker.visualization.trace.dependency.graph.AbstractDependencyGraphFormatter;
import kieker.visualization.trace.dependency.graph.DependencyGraphNode;

public abstract class AbstractOperationDependencyGraphFormatter<T extends AbstractDependencyGraph<?>>
extends AbstractDependencyGraphFormatter<T> {
    private String createOperationSignature(Operation operation) {
        StringBuilder builder = new StringBuilder();
        Signature signature = operation.getSignature();
        builder.append(signature.getName()).append('(');
        String[] parameterTypes = signature.getParamTypeList();
        if (parameterTypes.length > 0) {
            builder.append("..");
        }
        builder.append(')');
        return builder.toString();
    }

    protected String createOperationNodeLabel(Operation operation, DependencyGraphNode<?> node) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.createOperationSignature(operation));
        AbstractGraphFormatter.formatDecorations(builder, node);
        return builder.toString();
    }
}

