/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.display;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.analysis.display.AbstractDisplay;

public class XYPlot
extends AbstractDisplay {
    private final ConcurrentMap<String, CacheMap> entries = new ConcurrentHashMap<String, CacheMap>();
    private final int maxEntriesPerSeries;

    public XYPlot(int maxEntriesPerSeries) {
        this.maxEntriesPerSeries = maxEntriesPerSeries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Object, Number> getEntries(String key) {
        CacheMap cacheMap = (CacheMap)this.entries.get(key);
        synchronized (cacheMap) {
            return Collections.unmodifiableMap((Map)this.entries.get(key));
        }
    }

    public Set<String> getKeys() {
        return this.entries.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntry(String key, Object x, Number y) {
        CacheMap newCacheMap = new CacheMap(this.maxEntriesPerSeries);
        CacheMap oldCacheMap = this.entries.putIfAbsent(key, newCacheMap);
        CacheMap syncObj = oldCacheMap != null ? oldCacheMap : newCacheMap;
        CacheMap cacheMap = syncObj;
        synchronized (cacheMap) {
            syncObj.put(x, y);
        }
    }

    private static class CacheMap
    extends LinkedHashMap<Object, Number> {
        private static final long serialVersionUID = 1L;
        private final int maxEntriesPerSeries;

        public CacheMap(int maxEntriesPerSeries) {
            this.maxEntriesPerSeries = maxEntriesPerSeries;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, Number> entry) {
            return this.size() > this.maxEntriesPerSeries;
        }
    }
}

