/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.graph.dependency;

import kieker.analysis.graph.IGraph;
import kieker.analysis.graph.IVertex;
import kieker.analysis.graph.dependency.AbstractDependencyGraphBuilder;
import kieker.analysis.graph.dependency.vertextypes.VertexType;
import kieker.analysis.stage.model.ModelRepository;
import kieker.model.analysismodel.assembly.AssemblyComponent;
import kieker.model.analysismodel.assembly.AssemblyOperation;
import kieker.model.analysismodel.deployment.DeployedOperation;

public class AssemblyLevelOperationDependencyGraphBuilder
extends AbstractDependencyGraphBuilder {
    public AssemblyLevelOperationDependencyGraphBuilder(ModelRepository repository) {
        super(repository);
    }

    @Override
    protected IVertex addVertex(DeployedOperation deployedOperation) {
        AssemblyOperation operation = deployedOperation.getAssemblyOperation();
        AssemblyComponent component = operation.getAssemblyComponent();
        int componentId = this.identifierRegistry.getIdentifier(component);
        IVertex componentVertex = this.graph.addVertexIfAbsent(componentId);
        componentVertex.setPropertyIfAbsent("type", (Object)VertexType.ASSEMBLY_COMPONENT);
        componentVertex.setPropertyIfAbsent("name", component.getComponentType().getName());
        componentVertex.setPropertyIfAbsent("package name", component.getComponentType().getPackage());
        IGraph componentSubgraph = componentVertex.addChildGraphIfAbsent();
        int operationId = this.identifierRegistry.getIdentifier(operation);
        IVertex operationVertex = componentSubgraph.addVertexIfAbsent(operationId);
        operationVertex.setPropertyIfAbsent("type", (Object)VertexType.ASSEMBLY_OPERATION);
        operationVertex.setPropertyIfAbsent("name", operation.getOperationType().getName());
        operationVertex.setPropertyIfAbsent("return type", operation.getOperationType().getReturnType());
        operationVertex.setPropertyIfAbsent("modifiers", operation.getOperationType().getModifiers());
        operationVertex.setPropertyIfAbsent("parameter types", operation.getOperationType().getParameterTypes());
        this.responseTimeDecorator.decorate(operationVertex, operation);
        return operationVertex;
    }
}

