/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.graph.export.dot;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kieker.analysis.graph.IEdge;
import kieker.analysis.graph.IGraph;
import kieker.analysis.graph.IVertex;
import kieker.analysis.graph.util.dot.attributes.DotClusterAttribute;
import kieker.analysis.graph.util.dot.attributes.DotEdgeAttribute;
import kieker.analysis.graph.util.dot.attributes.DotGraphAttribute;
import kieker.analysis.graph.util.dot.attributes.DotNodeAttribute;

public class DotExportConfiguration {
    protected final Map<DotGraphAttribute, Function<IGraph, String>> graphAttributes = new EnumMap<DotGraphAttribute, Function<IGraph, String>>(DotGraphAttribute.class);
    protected final Map<DotNodeAttribute, Function<IGraph, String>> defaultNodeAttributes = new EnumMap<DotNodeAttribute, Function<IGraph, String>>(DotNodeAttribute.class);
    protected final Map<DotEdgeAttribute, Function<IGraph, String>> defaultEdgeAttributes = new EnumMap<DotEdgeAttribute, Function<IGraph, String>>(DotEdgeAttribute.class);
    protected final Map<DotNodeAttribute, Function<IVertex, String>> nodeAttributes = new EnumMap<DotNodeAttribute, Function<IVertex, String>>(DotNodeAttribute.class);
    protected final Map<DotEdgeAttribute, Function<IEdge, String>> edgeAttributes = new EnumMap<DotEdgeAttribute, Function<IEdge, String>>(DotEdgeAttribute.class);
    protected final Map<DotClusterAttribute, Function<IVertex, String>> clusterAttributes = new EnumMap<DotClusterAttribute, Function<IVertex, String>>(DotClusterAttribute.class);

    protected DotExportConfiguration() {
    }

    public Set<Map.Entry<DotGraphAttribute, Function<IGraph, String>>> getGraphAttributes() {
        return Collections.unmodifiableSet(this.graphAttributes.entrySet());
    }

    public Set<Map.Entry<DotNodeAttribute, Function<IGraph, String>>> getDefaultNodeAttributes() {
        return Collections.unmodifiableSet(this.defaultNodeAttributes.entrySet());
    }

    public Set<Map.Entry<DotEdgeAttribute, Function<IGraph, String>>> getDefaultEdgeAttributes() {
        return Collections.unmodifiableSet(this.defaultEdgeAttributes.entrySet());
    }

    public Set<Map.Entry<DotNodeAttribute, Function<IVertex, String>>> getNodeAttributes() {
        return Collections.unmodifiableSet(this.nodeAttributes.entrySet());
    }

    public Set<Map.Entry<DotEdgeAttribute, Function<IEdge, String>>> getEdgeAttributes() {
        return Collections.unmodifiableSet(this.edgeAttributes.entrySet());
    }

    public Set<Map.Entry<DotClusterAttribute, Function<IVertex, String>>> getClusterAttributes() {
        return Collections.unmodifiableSet(this.clusterAttributes.entrySet());
    }

    public static class Builder {
        private final DotExportConfiguration configuration = new DotExportConfiguration();

        public void addGraphAttribute(DotGraphAttribute attribute, Function<IGraph, String> function) {
            this.configuration.graphAttributes.put(attribute, function);
        }

        public void addDefaultNodeAttribute(DotNodeAttribute attribute, Function<IGraph, String> function) {
            this.configuration.defaultNodeAttributes.put(attribute, function);
        }

        public void addDefaultEdgeAttribute(DotEdgeAttribute attribute, Function<IGraph, String> function) {
            this.configuration.defaultEdgeAttributes.put(attribute, function);
        }

        public void addNodeAttribute(DotNodeAttribute attribute, Function<IVertex, String> function) {
            this.configuration.nodeAttributes.put(attribute, function);
        }

        public void addEdgeAttribute(DotEdgeAttribute attribute, Function<IEdge, String> function) {
            this.configuration.edgeAttributes.put(attribute, function);
        }

        public void addClusterAttribute(DotClusterAttribute attribute, Function<IVertex, String> function) {
            this.configuration.clusterAttributes.put(attribute, function);
        }

        public DotExportConfiguration build() {
            return this.configuration;
        }
    }
}

