/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.sink;

import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.display.MeterGauge;
import kieker.analysis.display.XYPlot;
import kieker.analysis.display.annotation.Display;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.system.CPUUtilizationRecord;

@Plugin(configuration={@Property(name="numberOfEntries", defaultValue="100", description="Sets the number of max plot entries per cpu"), @Property(name="displayWarningIntervals", defaultValue="70|90|100")})
public class CPUUtilizationDisplayFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_EVENTS = "inputEvents";
    public static final String CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES = "numberOfEntries";
    public static final String CONFIG_PROPERTY_VALUE_NUMBER_OF_ENTRIES = "100";
    public static final String CONFIG_PROPERTY_NAME_DISPLAY_WARNING_INTERVALS = "displayWarningIntervals";
    public static final String CONFIG_PROPERTY_VALUE_DISPLAY_WARNING_INTERVALS = "70|90|100";
    private static final String TOTAL_UTILIZATION = "totalUtilization";
    private static final String IDLE = "idle";
    private static final String IRQ = "irq";
    private static final String NICE = "nice";
    private static final String SYSTEM = "system";
    private static final String USER = "user";
    private final MeterGauge meterGauge;
    private final XYPlot xyplot;
    private final int numberOfEntries;
    private final Number[] warningIntervals;

    public CPUUtilizationDisplayFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.numberOfEntries = configuration.getIntProperty(CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES);
        String[] warningIntervalsAsString = configuration.getStringArrayProperty(CONFIG_PROPERTY_NAME_DISPLAY_WARNING_INTERVALS);
        this.warningIntervals = new Number[warningIntervalsAsString.length];
        for (int i = 0; i < warningIntervalsAsString.length; ++i) {
            this.warningIntervals[i] = Long.parseLong(warningIntervalsAsString[i]);
        }
        this.meterGauge = new MeterGauge();
        this.xyplot = new XYPlot(this.numberOfEntries);
    }

    @InputPort(name="inputEvents", eventTypes={CPUUtilizationRecord.class})
    public void input(CPUUtilizationRecord record) {
        this.updateDisplays(record);
    }

    private void updateDisplays(CPUUtilizationRecord record) {
        Date date = new Date(TimeUnit.MILLISECONDS.convert(record.getLoggingTimestamp(), this.recordsTimeUnitFromProjectContext));
        String minutesAndSeconds = date.toString().substring(14, 19);
        String id = record.getHostname() + " - " + record.getCpuID();
        this.meterGauge.setIntervals(id, Arrays.asList(this.warningIntervals), Arrays.asList("66cc66", "E7E658", "cc6666"));
        this.meterGauge.setValue(id, record.getTotalUtilization() * 100.0);
        this.xyplot.setEntry(id + " - " + TOTAL_UTILIZATION, minutesAndSeconds, record.getTotalUtilization() * 100.0);
        this.xyplot.setEntry(id + " - " + IDLE, minutesAndSeconds, record.getIdle() * 100.0);
        this.xyplot.setEntry(id + " - " + IRQ, minutesAndSeconds, record.getIrq() * 100.0);
        this.xyplot.setEntry(id + " - " + NICE, minutesAndSeconds, record.getNice() * 100.0);
        this.xyplot.setEntry(id + " - " + SYSTEM, minutesAndSeconds, record.getSystem() * 100.0);
        this.xyplot.setEntry(id + " - " + USER, minutesAndSeconds, record.getUser() * 100.0);
    }

    @Display(name="Meter Gauge CPU total utilization Display")
    public MeterGauge getMeterGauge() {
        return this.meterGauge;
    }

    @Display(name="XYPlot CPU utilization Display")
    public XYPlot getXYPlot() {
        return this.xyplot;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES, String.valueOf(this.numberOfEntries));
        configuration.setProperty(CONFIG_PROPERTY_NAME_DISPLAY_WARNING_INTERVALS, Configuration.toProperty(this.warningIntervals));
        return configuration;
    }
}

