/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.sink;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.display.XYPlot;
import kieker.analysis.display.annotation.Display;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.jvm.ThreadsStatusRecord;

@Plugin(configuration={@Property(name="numberOfEntries", defaultValue="100", description="Sets the number of max plot entries per record entry")})
public class ThreadsStatusDisplayFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_EVENTS = "inputEvents";
    public static final String CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES = "numberOfEntries";
    public static final String CONFIG_PROPERTY_VALUE_NUMBER_OF_ENTRIES = "100";
    private static final String TOTAL_THREADS = "Total Threads";
    private static final String THREADS = "Threads";
    private static final String DAEMON_THREADS = "Daemon Threads";
    private static final String PEAK_THREADS = "Peak Threads";
    private final XYPlot xyplot;
    private final int numberOfEntries;

    public ThreadsStatusDisplayFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.numberOfEntries = configuration.getIntProperty(CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES);
        this.xyplot = new XYPlot(this.numberOfEntries);
    }

    @InputPort(name="inputEvents", eventTypes={ThreadsStatusRecord.class})
    public void input(ThreadsStatusRecord record) {
        this.updateDisplays(record);
    }

    private void updateDisplays(ThreadsStatusRecord record) {
        Date date = new Date(TimeUnit.MILLISECONDS.convert(record.getLoggingTimestamp(), this.recordsTimeUnitFromProjectContext));
        String minutesAndSeconds = date.toString().substring(14, 19);
        String id = record.getHostname() + " - " + record.getVmName();
        this.xyplot.setEntry(id + " - " + THREADS, minutesAndSeconds, record.getThreadCount());
        this.xyplot.setEntry(id + " - " + TOTAL_THREADS, minutesAndSeconds, record.getTotalStartedThreadCount());
        this.xyplot.setEntry(id + " - " + PEAK_THREADS, minutesAndSeconds, record.getPeakThreadCount());
        this.xyplot.setEntry(id + " - " + DAEMON_THREADS, minutesAndSeconds, record.getDaemonThreadCount());
    }

    @Display(name="XYPlot Display")
    public XYPlot getXYPlot() {
        return this.xyplot;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES, String.valueOf(this.numberOfEntries));
        return configuration;
    }
}

