/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.jmx;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.CountDownLatch;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import org.slf4j.Logger;

@Plugin(description="A reader which reads records from a JMX queue", outputPorts={@OutputPort(name="monitoringRecords", eventTypes={IMonitoringRecord.class}, description="Output Port of the JmxReader")}, configuration={@Property(name="server", defaultValue="localhost", description="The address of the server used for the JMX connection."), @Property(name="port", defaultValue="59999", description="The port of the server used for the JMX connection."), @Property(name="serviceUrl", defaultValue="", description="As an alternative to specifiying server and port, a service URL can be given. This value is ignored if port > 0."), @Property(name="domain", defaultValue="kieker.monitoring", description="The JMX domain used by the JMXWriter."), @Property(name="logname", defaultValue="MonitoringLog", description="The logname used by the JMXWriter."), @Property(name="silentReconnect", defaultValue="false", description="Whether the JmxReader should silently reconnect on any errors. This prevents termination of the reader!")})
public final class JmxReader
extends AbstractReaderPlugin {
    public static final String OUTPUT_PORT_NAME_RECORDS = "monitoringRecords";
    public static final String CONFIG_PROPERTY_NAME_SERVER = "server";
    public static final String CONFIG_PROPERTY_NAME_PORT = "port";
    public static final String CONFIG_PROPERTY_NAME_SERVICEURL = "serviceUrl";
    public static final String CONFIG_PROPERTY_NAME_DOMAIN = "domain";
    public static final String CONFIG_PROPERTY_NAME_LOGNAME = "logname";
    public static final String CONFIG_PROPERTY_NAME_SILENT = "silentReconnect";
    final boolean silentreconnect;
    private final JMXServiceURL serviceURL;
    private final ObjectName monitoringLog;
    private final CountDownLatch cdLatch = new CountDownLatch(1);
    private final String domain;
    private final String logname;
    private final int port;
    private final String server = this.configuration.getStringProperty("server");

    public JmxReader(Configuration configuration, IProjectContext projectContext) throws IllegalArgumentException {
        super(configuration, projectContext);
        this.port = this.configuration.getIntProperty(CONFIG_PROPERTY_NAME_PORT);
        String tmpServiceURL = this.port > 0 ? "service:jmx:rmi:///jndi/rmi://" + this.server + ":" + this.port + "/jmxrmi" : this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_SERVICEURL);
        this.domain = this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_DOMAIN);
        this.logname = this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_LOGNAME);
        if (tmpServiceURL.length() == 0) {
            throw new IllegalArgumentException("JmxReader has not sufficient parameters. Set either port or serviceURL");
        }
        try {
            this.serviceURL = new JMXServiceURL(tmpServiceURL);
            this.monitoringLog = new ObjectName(this.domain, "type", this.logname);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Failed to parse configuration.", e);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to parse configuration.", e);
        }
        this.silentreconnect = this.configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_SILENT);
    }

    @Override
    public void terminate(boolean error) {
        this.logger.info("Shutdown of JmxReader requested.");
        this.unblock();
    }

    /*
     * Exception decompiling
     */
    @Override
    public final boolean read() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final boolean read2() {
        while (true) {
            JMXConnector jmx = null;
            MBeanServerConnection mbServer = null;
            ServerNotificationListener serverNotificationListener = null;
            LogNotificationListener logNotificationListener = null;
            try {
                jmx = JMXConnectorFactory.connect(this.serviceURL);
            }
            catch (IOException e2222222222) {
                Thread.sleep(10000L);
                try {
                    if (logNotificationListener != null) {
                        mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (serverNotificationListener != null) {
                        jmx.removeConnectionNotificationListener(serverNotificationListener);
                    }
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
                try {
                    if (jmx != null) {
                        jmx.close();
                    }
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {}
                continue;
            }
            serverNotificationListener = new ServerNotificationListener();
            jmx.addConnectionNotificationListener(serverNotificationListener, null, null);
            mbServer = jmx.getMBeanServerConnection();
            logNotificationListener = new LogNotificationListener();
            mbServer.addNotificationListener(this.monitoringLog, logNotificationListener, null, null);
            this.logger.info("Connected to JMX Server, ID: {}", (Object)jmx.getConnectionId());
            this.block();
            this.logger.info("Shutting down JmxReader");
            try {
                if (logNotificationListener != null) {
                    mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                }
            }
            catch (Exception e2222222222) {
                // empty catch block
            }
            try {
                if (serverNotificationListener != null) {
                    jmx.removeConnectionNotificationListener(serverNotificationListener);
                }
            }
            catch (ListenerNotFoundException e2222222222) {
                // empty catch block
            }
            try {
                if (jmx != null) {
                    jmx.close();
                }
                Thread.sleep(10000L);
            }
            catch (Exception e2222222222) {}
            continue;
            catch (InstanceNotFoundException e2222222222) {
                try {
                    if (logNotificationListener != null) {
                        mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                    }
                }
                catch (Exception e2222222222) {
                    // empty catch block
                }
                try {
                    if (serverNotificationListener != null) {
                        jmx.removeConnectionNotificationListener(serverNotificationListener);
                    }
                }
                catch (ListenerNotFoundException e2222222222) {
                    // empty catch block
                }
                try {
                    if (jmx != null) {
                        jmx.close();
                    }
                    Thread.sleep(10000L);
                }
                catch (Exception e2222222222) {}
                continue;
            }
            catch (Exception e) {
                this.logger.error("Error in JMX connection!", (Throwable)e);
                {
                    catch (Throwable throwable) {
                        try {
                            if (logNotificationListener != null) {
                                mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (serverNotificationListener != null) {
                                jmx.removeConnectionNotificationListener(serverNotificationListener);
                            }
                        }
                        catch (ListenerNotFoundException listenerNotFoundException) {
                            // empty catch block
                        }
                        try {
                            if (jmx != null) {
                                jmx.close();
                            }
                            Thread.sleep(10000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    if (logNotificationListener != null) {
                        mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (serverNotificationListener != null) {
                        jmx.removeConnectionNotificationListener(serverNotificationListener);
                    }
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
                try {
                    if (jmx != null) {
                        jmx.close();
                    }
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {}
                continue;
            }
            break;
        }
    }

    private final void block() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public final void run() {
                JmxReader.this.unblock();
            }
        });
        try {
            this.cdLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    final void unblock() {
        this.cdLatch.countDown();
    }

    final boolean deliverIndirect(String outputPortName, Object data) {
        return super.deliver(outputPortName, data);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_SERVER, this.server);
        configuration.setProperty(CONFIG_PROPERTY_NAME_PORT, Integer.toString(this.port));
        configuration.setProperty(CONFIG_PROPERTY_NAME_SERVICEURL, this.serviceURL.toString());
        configuration.setProperty(CONFIG_PROPERTY_NAME_DOMAIN, this.domain);
        configuration.setProperty(CONFIG_PROPERTY_NAME_LOGNAME, this.logname);
        configuration.setProperty(CONFIG_PROPERTY_NAME_SILENT, Boolean.toString(this.silentreconnect));
        return configuration;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private final class ServerNotificationListener
    implements NotificationListener {
        @Override
        public final void handleNotification(Notification notification, Object handback) {
            String notificationType = notification.getType();
            if (notificationType.equals("jmx.remote.connection.closed")) {
                if (!JmxReader.this.silentreconnect) {
                    JmxReader.this.getLogger().info("JMX connection closed.");
                }
                JmxReader.this.unblock();
            } else if (notificationType.equals("jmx.remote.connection.failed")) {
                if (!JmxReader.this.silentreconnect) {
                    JmxReader.this.getLogger().info("JMX connection lost.");
                }
                JmxReader.this.unblock();
            } else if (notificationType.equals("jmx.remote.connection.notifs.lost")) {
                JmxReader.this.getLogger().error("Monitoring record lost: {}", (Object)notification.getMessage());
            } else {
                JmxReader.this.getLogger().info("{}: {}", (Object)notificationType, (Object)notification.getMessage());
            }
        }
    }

    private final class LogNotificationListener
    implements NotificationListener {
        @Override
        public final void handleNotification(Notification notification, Object handback) {
            JmxReader.this.deliverIndirect(JmxReader.OUTPUT_PORT_NAME_RECORDS, notification.getUserData());
        }
    }
}

