/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.sink.display;

import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kieker.analysis.display.MeterGauge;
import kieker.analysis.display.XYPlot;
import kieker.analysis.display.annotation.Display;
import kieker.common.record.system.CPUUtilizationRecord;
import teetime.framework.AbstractConsumerStage;

public class CPUUtilizationDisplaySink
extends AbstractConsumerStage<CPUUtilizationRecord> {
    public static final String TOTAL_UTILIZATION = "totalUtilization";
    public static final String IDLE = "idle";
    public static final String IRQ = "irq";
    public static final String NICE = "nice";
    public static final String SYSTEM = "system";
    public static final String USER = "user";
    private final MeterGauge meterGauge;
    private final XYPlot xyplot;
    private final Number[] warningIntervals;
    private final TimeUnit recordsTimeUnit;

    public CPUUtilizationDisplaySink(int numberOfEntries, Number[] warningIntervals, TimeUnit recordsTimeUnit) {
        this.warningIntervals = (Number[])warningIntervals.clone();
        this.recordsTimeUnit = recordsTimeUnit;
        this.meterGauge = new MeterGauge();
        this.xyplot = new XYPlot(numberOfEntries);
    }

    protected void execute(CPUUtilizationRecord record) {
        this.updateDisplays(record);
    }

    private void updateDisplays(CPUUtilizationRecord record) {
        Date date = new Date(TimeUnit.MILLISECONDS.convert(record.getLoggingTimestamp(), this.recordsTimeUnit));
        String minutesAndSeconds = date.toString().substring(14, 19);
        String id = record.getHostname() + " - " + record.getCpuID();
        this.meterGauge.setIntervals(id, Arrays.asList(this.warningIntervals), Arrays.asList("66cc66", "E7E658", "cc6666"));
        this.meterGauge.setValue(id, record.getTotalUtilization() * 100.0);
        this.xyplot.setEntry(id + " - " + TOTAL_UTILIZATION, minutesAndSeconds, record.getTotalUtilization() * 100.0);
        this.xyplot.setEntry(id + " - " + IDLE, minutesAndSeconds, record.getIdle() * 100.0);
        this.xyplot.setEntry(id + " - " + IRQ, minutesAndSeconds, record.getIrq() * 100.0);
        this.xyplot.setEntry(id + " - " + NICE, minutesAndSeconds, record.getNice() * 100.0);
        this.xyplot.setEntry(id + " - " + SYSTEM, minutesAndSeconds, record.getSystem() * 100.0);
        this.xyplot.setEntry(id + " - " + USER, minutesAndSeconds, record.getUser() * 100.0);
    }

    @Display(name="Meter Gauge CPU total utilization Display")
    public MeterGauge getMeterGauge() {
        return this.meterGauge;
    }

    @Display(name="XYPlot CPU utilization Display")
    public XYPlot getXYPlot() {
        return this.xyplot;
    }
}

