/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.stage.adaptation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kieker.analysis.stage.adaptation.IProbeController;
import kieker.analysis.stage.adaptation.RemoteControlFailedException;
import kieker.analysis.stage.adaptation.TcpControlConnection;
import kieker.analysis.stage.adaptation.events.AbstractTcpControlEvent;
import kieker.analysis.stage.adaptation.events.TcpActivationControlEvent;
import kieker.analysis.stage.adaptation.events.TcpActivationParameterControlEvent;
import kieker.analysis.stage.adaptation.events.TcpDeactivationControlEvent;
import kieker.analysis.stage.adaptation.events.TcpUpdateParameterEvent;
import kieker.common.record.remotecontrol.ActivationEvent;
import kieker.common.record.remotecontrol.ActivationParameterEvent;
import kieker.common.record.remotecontrol.DeactivationEvent;
import kieker.common.record.remotecontrol.IRemoteControlEvent;
import kieker.common.record.remotecontrol.IRemoteParameterControlEvent;
import kieker.common.record.remotecontrol.UpdateParameterEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyProbeController
implements IProbeController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DummyProbeController.class);
    private final Map<String, TcpControlConnection> knownAddresses = new HashMap<String, TcpControlConnection>();

    @Override
    public void controlProbe(AbstractTcpControlEvent event) throws RemoteControlFailedException {
        LOGGER.debug("control probe host=[{}] ip=[{}] port=[{}]", new Object[]{event.getServiceComponent(), event.getIp(), event.getPort()});
        String ip = event.getIp();
        int port = event.getPort();
        String hostname = event.getServiceComponent();
        String pattern = event.getOperationSignature();
        if (event instanceof TcpActivationControlEvent) {
            if (event instanceof TcpActivationParameterControlEvent) {
                this.activateParameterMonitoredPattern(ip, port, hostname, pattern, ((TcpActivationParameterControlEvent)event).getParameters());
            } else {
                this.activateMonitoredPattern(ip, port, hostname, pattern);
            }
        } else if (event instanceof TcpDeactivationControlEvent) {
            this.deactivateMonitoredPattern(ip, port, hostname, pattern);
        } else if (event instanceof TcpUpdateParameterEvent) {
            this.updateProbeParameter(ip, port, hostname, pattern, ((TcpUpdateParameterEvent)event).getParameters());
        } else {
            LOGGER.error("Received Unknown TCP control event: {}", (Object)event.getClass().getName());
        }
    }

    public void updateProbeParameter(String ip, int port, String hostname, String pattern, Map<String, List<String>> parameters) throws RemoteControlFailedException {
        for (Map.Entry<String, List<String>> parameter : parameters.entrySet()) {
            String[] parameterArray = this.computeParameterArray(parameter.getValue());
            this.sendTcpCommand(ip, port, hostname, new UpdateParameterEvent(pattern, parameter.getKey(), parameterArray));
        }
    }

    public void activateMonitoredPattern(String ip, int port, String hostname, String pattern) throws RemoteControlFailedException {
        this.sendTcpCommand(ip, port, hostname, new ActivationEvent(pattern));
    }

    public void activateParameterMonitoredPattern(String ip, int port, String hostname, String operationSignature, Map<String, List<String>> parameters) throws RemoteControlFailedException {
        for (Map.Entry<String, List<String>> parameter : parameters.entrySet()) {
            String[] parameterArray = this.computeParameterArray(parameter.getValue());
            this.sendTcpCommand(ip, port, hostname, new ActivationParameterEvent(operationSignature, parameter.getKey(), parameterArray));
        }
    }

    public void deactivateMonitoredPattern(String ip, int port, String hostname, String pattern) throws RemoteControlFailedException {
        this.sendTcpCommand(ip, port, hostname, new DeactivationEvent(pattern));
    }

    private void sendTcpCommand(String ip, int port, String hostname, IRemoteControlEvent monitoringRecord) throws RemoteControlFailedException {
        String writerKey = ip + ":" + port;
        TcpControlConnection currentConnection = this.knownAddresses.get(writerKey);
        if (currentConnection == null || currentConnection.getServiceComponent() != hostname) {
            currentConnection = new TcpControlConnection(ip, port, hostname, null);
            this.knownAddresses.put(writerKey, currentConnection);
        }
        LOGGER.debug("Event time={} size={} pattern={}", new Object[]{monitoringRecord.getLoggingTimestamp(), monitoringRecord.getSize(), monitoringRecord.getPattern()});
        Class<?>[] types = monitoringRecord.getValueTypes();
        String[] values = monitoringRecord.getValueNames();
        LOGGER.debug("--------------- Provided attributes of the event ---------------");
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = monitoringRecord.getValueTypes()[i];
            LOGGER.debug("\t attribute type={}", (Object)type.getCanonicalName());
            if (i >= values.length) continue;
            String value = monitoringRecord.getValueNames()[i];
            LOGGER.debug("\t attribute name={}", (Object)value);
        }
        if (monitoringRecord instanceof IRemoteParameterControlEvent) {
            LOGGER.debug("--------------- Parameter Control Event ---------------");
            this.printParameters(((IRemoteParameterControlEvent)monitoringRecord).getName(), ((IRemoteParameterControlEvent)monitoringRecord).getValues());
            LOGGER.debug("-------------------------------------------------------");
        }
        LOGGER.debug("Send record {} to {} on port: {}", new Object[]{monitoringRecord.getClass().getName(), ip, port});
    }

    public boolean isKnownHost(String ip, int port) {
        return this.knownAddresses.keySet().contains(ip + ":" + port);
    }

    private String[] computeParameterArray(List<String> parameters) {
        return parameters.toArray(new String[parameters.size()]);
    }

    private void printParameters(String name, String[] values) {
        LOGGER.debug(">> {}", (Object)name);
        for (String value : values) {
            LOGGER.debug("\t - {}", (Object)value);
        }
    }
}

